@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="deleteall">
                    <i class="fa fa-trash-alt"></i> Delete Selected
                </button>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer">
                    <i class="fa fa-plus"></i> Register Location
                </button>
            </div>

            <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Register Location</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{ route('location.store') }}" onsubmit="showSpinner()" method="post"
                            class="was-validated">
                            @csrf
                            @method('POST')

                            <div class="modal-body">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control" id="name" required>

                                <label for="owner">Owner</label>
                                <input type="text" name="owner" class="form-control" id="owner" required>

                                <label for="phone">Phone</label>
                                <input type="text" name="phone" class="form-control" id="phone" required>

                                <label for="status">Location Status</label>
                                <select name="status" id="status" class="form-control" required>
                                    <option disabled selected value="">-- Select Location Status --</option>
                                    <option value="static">-- Static --</option>
                                    <option value="dynamic">-- Dynamic --</option>
                                </select>

                                <label for="type">Location Type</label>
                                <select name="type" id="type" class="form-control type" required>
                                    <option disabled selected value="">-- Select Location Type --</option>
                                    <option value="main">-- Main Location --</option>
                                    <option value="selling">-- Selling Point --</option>
                                    <option value="storage">-- Storage Point --</option>
                                </select>

                                <div class="maindiv" style="display: none">
                                    <label for="main">Main location</label>
                                    <select name="main" id="main" class="form-control main" required>
                                        <option disabled selected value="">-- Select Main Location --
                                        </option>
                                        @foreach ($mainLocations as $mainLocation)
                                            <option value="{{ $mainLocation->id }}">-- {{ $mainLocation->location->name }}
                                                --
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="sellingdiv" style="display: none">
                                    <label for="selling">Selling location</label>
                                    <select name="selling" id="selling" class="form-control selling" required>
                                        <option disabled selected value="">-- Select Selling Location --
                                        </option>
                                        @foreach ($sellingLocations as $sellingLocation)
                                            <option value="{{ $sellingLocation->id }}">--
                                                {{ $sellingLocation->location->name }} --</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-info btn-block"><i class="fa fa-paper-plane"></i>
                                    Register</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle shadow-sm" id="data-table">
                    <thead class="thead-dark">
                        <tr>
                            <th style="width: 5%;" class="text-center"><input type="checkbox" id="checkall"
                                    class="text-center"></th>
                            <th class="text-center">S/N</th>
                            <th class="text-center">Name</th>
                            <th class="text-center">Owner</th>
                            <th class="text-center">Phone</th>
                            <th class="text-center">Type</th>
                            <th style="width: 20%;" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($all_locations as $location)
                            <tr>
                                <td class="text-center">
                                    <input type="checkbox" id="{{ $location->id }}" class="selected sub_chk text-center">
                                </td>
                                <td class="fw-bold text-secondary text-center">{{ $loop->iteration }}</td>
                                <td class="text-capitalize text-center">{{ $location->name }}</td>
                                <td class="text-capitalize text-center">{{ $location->owner }}</td>
                                <td class="text-center">
                                    <span class="badge badge-info">{{ $location->phone }}</span>
                                </td>
                                <td class="text-center">
                                    <span
                                        class="badge badge-{{ $location->type == 'main' ? 'primary' : ($location->type == 'selling' ? 'success' : 'warning') }}">
                                        {{ ucfirst($location->type) }} Point
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <!-- Edit Button -->
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                            data-target="#edit-{{ $location->id }}" title="Edit">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit
                                        </button>
                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="edit-{{ $location->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="editLabel{{ $location->id }}"
                                            aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('location.update', $location->id) }}"
                                                        onsubmit="showSpinner()" id="location_form" method="get"
                                                        class="was-validated">
                                                        <div class="modal-header bg-info text-white">
                                                            <h5 class="modal-title" id="editLabel{{ $location->id }}">
                                                                Update Location Details</h5>
                                                            <button type="button" class="close text-white"
                                                                data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <label for="name">Name</label>
                                                            <input type="text" name="name"
                                                                class="form-control mb-2" value="{{ $location->name }}"
                                                                id="name" required>
                                                            <label for="owner">Owner</label>
                                                            <input type="text" name="owner"
                                                                class="form-control mb-2" value="{{ $location->owner }}"
                                                                id="address" required>
                                                            <label for="phone">Phone</label>
                                                            <input type="text" name="phone" id="phone"
                                                                class="form-control mb-2" value="{{ $location->phone }}"
                                                                required>
                                                            <label for="type">Location Type</label>
                                                            <select name="type" id="type"
                                                                class="form-control type mb-2" required>
                                                                <option selected value="{{ $location->type }}">
                                                                    -- {{ ucfirst($location->type) }} --
                                                                </option>
                                                                <option value="main">-- Main --</option>
                                                                <option value="selling">-- Selling --</option>
                                                                <option value="storage">-- Storage --</option>
                                                            </select>
                                                            <div class="maindiv" style="display: none">
                                                                <label for="main">Main location</label>
                                                                <select name="main" id="main"
                                                                    class="form-control main mb-2" required>
                                                                    <option disabled selected value="">-- Select Main
                                                                        Location --</option>
                                                                    @foreach ($mainLocations as $mainLocation)
                                                                        <option value="{{ $mainLocation->id }}">--
                                                                            {{ $mainLocation->location->name }} --</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="sellingdiv" style="display: none">
                                                                <label for="selling">Selling location</label>
                                                                <select name="selling" id="selling"
                                                                    class="form-control selling mb-2" required>
                                                                    <option selected
                                                                        value="{{ $location->selling_location }}">
                                                                        {{ $location->selling_location }}</option>
                                                                    @foreach ($sellingLocations as $sellingLocation)
                                                                        <option value="{{ $sellingLocation->id }}">
                                                                            -- {{ $sellingLocation->location->name }} --
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <label for="status">Location Status</label>
                                                            <select name="status" id="status"
                                                                class="form-control mb-2" required>
                                                                <option disabled selected value="">--Select location
                                                                    status--</option>
                                                                <option selected value="{{ $location->status }}">
                                                                    {{ ucfirst($location->status) }}</option>
                                                                <option value="static">-- Static --</option>
                                                                <option value="dynamic">-- Dynamic --</option>
                                                            </select>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button class="btn btn-info btn-block">
                                                                <i class="fa-solid fa-paper-plane"></i> Save Updates
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Delete Button -->
                                        <button class="btn btn-danger delete" id="{{ $location->id }}" title="Delete">
                                            <i class="fa fa-trash-alt"></i> Delete
                                            <form action="{{ route('location.delete', $location->id) }}"
                                                onsubmit="showSpinner()" method="GET"
                                                id="deleteform{{ $location->id }}">
                                            </form>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Locations Found</h5>
                                        <p class="text-muted mb-0">You haven't added any locations yet.<br>
                                            <span class="small">Click <strong>Register Location</strong> to get
                                                started.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="thead-light">
                        <tr>
                            <th style="width: 5%;" class="text-center"><input type="checkbox" id="checkall"
                                    class="text-center"></th>
                            <th class="text-center">S/N</th>
                            <th class="text-center">Name</th>
                            <th class="text-center">Owner</th>
                            <th class="text-center">Phone</th>
                            <th class="text-center">Type</th>
                            <th style="width: 20%;" class="text-center">Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $('.type').on("change", function() {
                $("#example1").DataTable();

                var change = $(this).val();
                if (change === "storage") {
                    $('.sellingdiv').fadeIn("slow");
                    $('.selling').prop("required", true).prop("disabled", false);

                    $('.maindiv').fadeOut("slow");
                    $('.main').prop("required", false).prop("disabled", true);
                } else if (change === "selling") {
                    $('.maindiv').fadeIn("slow");
                    $('.main').prop("required", true).prop("disabled", false);

                    $('.sellingdiv').fadeOut("slow");
                    $('.selling').prop("required", false).prop("disabled", true);
                } else if (change === "main") {
                    $('.maindiv').fadeOut("slow");
                    $('.main').prop("required", false).prop("disabled", true);

                    $('.sellingdiv').fadeOut("slow");
                    $('.selling').prop("required", false).prop("disabled", true);
                }
            });

            $('#checkall').on('click', function() {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }

            });

            $("#deleteall").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('location.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success!',
                                    text: 'Selected location deleted successfully.',
                                    background: '#e6ffed',
                                    showConfirmButton: false,
                                    timer: 2500,
                                    timerProgressBar: true,
                                    position: 'top-end',
                                    toast: true,
                                    customClass: {
                                        popup: 'swal2-border-radius'
                                    }
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
