@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Loaded vehicle</h3>
            </div>

            <div class="card-body">
                <table id="data-table" class="table table-striped table-bordered text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>Load Date</th>
                            <th>Vehicle</th>
                            <th>Driver</th>
                            <th>Salesmen</th>
                            <th>Load Value</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @forelse ($loaded_vehicles as $vehicle)
                            <tr>
                                <td>{{ $vehicle->date }}</td>
                                <td>{{ $vehicle->vehicle->name }}</td>
                                <td>{{ $vehicle->driver->name }}</td>
                                <td>{{ $vehicle->salesmen->name }}</td>
                                <td>{{ number_format($vehicle->total, 2) }}</td>
                                <td>
                                    @if ($vehicle->status === 'Completed')
                                        <span class="badge badge-success">Completed</span>
                                    @else
                                        <span class="badge badge-warning">{{ $vehicle->status }}</span>
                                    @endif
                                </td>
                                <td>
                                    <!-- View Details Button -->
                                    <button type="button" class="btn btn-outline-secondary btn-sm" data-toggle="modal"
                                        data-target="#detailsModal-{{ $vehicle->id }}">
                                        <i class="fa fa-eye"></i>
                                    </button>

                                    <!-- Delete Button -->
                                    <form action="{{ route('delete.loaded.vehicle', $vehicle->id) }}" method="GET"
                                        class="d-inline">
                                        <button type="submit" class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>

                                    <!-- Details Modal -->
                                    <div class="modal fade" id="detailsModal-{{ $vehicle->id }}" tabindex="-1"
                                        role="dialog" aria-labelledby="detailsModalLabel-{{ $vehicle->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-scrollable">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Load Details: {{ $vehicle->vehicle->name }}
                                                    </h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <div class="modal-body">
                                                    <button class="btn btn-danger mb-2" id="bulkdelete">Delete
                                                        selected</button>

                                                    <table class="table table-bordered table-striped">
                                                        <thead class="thead-light">
                                                            <tr>
                                                                <th width="50px">
                                                                    <input type="checkbox" id="master">
                                                                </th>
                                                                <th>Items</th>
                                                                <th>Qty</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach ($loaded_items as $item)
                                                                <tr>
                                                                    <td>
                                                                        <input type="checkbox" class="sub_chk"
                                                                            data-id="{{ $item->id }}">
                                                                    </td>
                                                                    <td>{{ $item->product }}</td>
                                                                    <td>
                                                                        @php
                                                                            $answer = [];
                                                                            $units = App\Models\UnitAssigned::where(
                                                                                'location_id',
                                                                                $vehicle->vehicle_id,
                                                                            )
                                                                                ->where('product_id', $item->product_id)
                                                                                ->whereNotNull('unit_id')
                                                                                ->orderByDesc('unit_cont')
                                                                                ->get();

                                                                            $remainder = $item->qty;
                                                                            $x = 0;

                                                                            while (
                                                                                $remainder > 0 &&
                                                                                isset($units[$x])
                                                                            ) {
                                                                                $current_cont = $units[$x]->unit_cont;
                                                                                if ($remainder >= $current_cont) {
                                                                                    $current_qty = intdiv(
                                                                                        $remainder,
                                                                                        $current_cont,
                                                                                    );
                                                                                    $remainder =
                                                                                        $remainder % $current_cont;
                                                                                    if ($current_qty) {
                                                                                        $answer[] =
                                                                                            $current_qty .
                                                                                            ' ' .
                                                                                            $units[$x]->unit;
                                                                                    }
                                                                                }
                                                                                $x++;
                                                                            }
                                                                        @endphp
                                                                        {{ implode(', ', $answer) }}
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">Close</button>
                                                    <!-- Optional: Add Save Changes or other buttons -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Vehicle Found</h5>
                                        <p class="text-muted mb-0">You haven't loaded any vehicle yet.<br>
                                            <a href="{{ route('load.vehicle.view') }}" class="btn btn-primary btn-sm">
                                                <i class="fa-solid fa-truck-loading"></i> Load Vehicle
                                            </a>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

            </div>
        </div>
    </div>
    {{-- /.content --}}

    @section('scripts')
        <script>
            $('#master').on('click', function(e) {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }

            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('loaded.items.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
