@extends('layouts.master')

@section('content')

    <div class="card table-responsive">

        <div class="card-header">
            <h5>Load vehicle <i class="fa-solid fa-truck-loading"></i></h5>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <div class="row align-items-center">
                    <div class="col-md-7 mb-2 mb-md-0">
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white">
                                <i class="fas fa-barcode"></i>
                            </span>
                            <input type="search" id="search" class="form-control search"
                                placeholder="Enter product name or barcode...">
                        </div>
                        <div id="list"
                            style="display:none; position: absolute; z-index: 10; width: 98%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                            class="bg-white border border-primary">
                            <ol id="results" class="list-group list-group-flush"></ol>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="input-group shadow-sm">
                            <span class="input-group-text bg-info text-white">
                                <i class="fas fa-store"></i>
                            </span>
                            <select name="area" id="area" class="form-control" style="text-align: center" required>
                                <option disabled selected>-- Choose Location --</option>
                                @foreach ($sellings as $selling)
                                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                                    </option>
                                @endforeach

                                @foreach ($storages as $storage)
                                    <option value="{{ $storage->location_id }}">-- {{ $storage->location->name }} --
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <br>

            <form action="{{ route('load.vehicle.store') }}" method="post">
                @csrf
                @method('POST')

                <div class="row">
                    <div class="col-9">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover align-middle shadow-sm"
                                style="background: #fff;">
                                <thead class="table-secondary text-center align-middle">
                                    <tr>
                                        <th style="width: 20%">Product</th>
                                        <th style="width:10%">Unit</th>
                                        <th style="width:12%">Price</th>
                                        <th style="width: 20%">Qty</th>
                                        <th style="width:12%">Amount</th>
                                        <th style="width:5%">Action</th>
                                    </tr>
                                </thead>

                                <tbody id="tbody">
                                    {{-- Dynamic JS rows --}}
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col">
                        <input type="date" name="date" value="{{ date('Y-m-d') }}" class="form-control"
                            style="text-align: center">

                        <input type="text" name="total" id="total" class="form-control" style="text-align: center"
                            placeholder="Total" readonly>

                        <select name="vehicle" id="vehicle" class="form-control text-center" required>
                            <option disabled selected value="">--Vehicle--</option>
                            @foreach ($sellings as $vehicle)
                                @if (optional($vehicle->location)->status == 'dynamic')
                                    <option value="{{ $vehicle->id }}">-- {{ $vehicle->location->name }} --</option>
                                @endif
                            @endforeach
                        </select>

                        <select name="driver" id="driver" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Driver --</option>
                            @foreach ($drivers as $driver)
                                <option value="{{ $driver->id }}">-- {{ $driver->name }} --</option>
                            @endforeach
                        </select>

                        <select name="salesman" id="salesmen" class="form-control" style="text-align: center" required>
                            <option disabled selected value="">-- Salesmen --</option>
                            @foreach ($salesmen as $salesman)
                                <option value="{{ $salesman->id }}">-- {{ $salesman->name }} --</option>
                            @endforeach
                        </select>

                        <input type="hidden" name="location" id="location" class="form-control"
                            style="text-align: center">

                        <br>

                        <button class="btn btn-primary btn-block"><i class="fa fa-paper-plane"></i> Confirm</button>

                        <form action="" method="get">
                            <button class="btn btn-danger btn-block"><i class="fa fa-times"></i> Cancel</button>
                        </form>
                    </div>
                </div>
            </form>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            // Initiate variable
            let location;
            let index;

            // Create a new Intl.NumberFormat object
            var formatter = new Intl.NumberFormat();

            $("#area").on("change", function() {
                location = $(this).val();
                $("#location").val(location);
                $("#search").focus();
            });

            let isFunctionRunning = false;

            $("#search").on("change", function() {
                if (isFunctionRunning) {
                    return; // Skip execution if a function is already running
                }

                isFunctionRunning = true;

                let barcode = $(this).val();
                let locationId = $("#location").val();
                let csrfToken = '{{ csrf_token() }}';

                $.ajax({
                    url: "{{ route('get.product.by.barcode') }}",
                    method: "GET",
                    data: {
                        'barcode': barcode,
                        'locationId': locationId,
                    },
                    headers: {
                        'X-CSRF-TOKEN': csrfToken
                    },
                    success: function(data) {
                        // console.log(data);

                        if (data.length === 0) {
                            $("#search").val("");
                            $("#search").focus();
                        } else {
                            let units = '';
                            let unitprice = 0;
                            let profit = 0;

                            for (let i = 0; i < data[0].unit.length; i++) {
                                units += '<option value="' + data[0].unit[i].unit.id +
                                    '">' + data[0].unit[i].unit.name + '</option>';
                                if (i === 0) {
                                    unitprice = data[0].unit[i].selling;

                                    // Format the value using the format() method
                                    unitprice = formatter.format(unitprice);
                                }
                            }

                            let tr = `
                                <tr id="tr${index}">
                                <td style="text-align: center;">
                                    <input type="hidden" name="id[]" value="${data[0].id}" id="id${index}" class="form-control id" readonly>
                                    <input type="hidden" name="area[]" value="${data[0].location_id}" id="area${index}" class="form-control area" readonly>
                                    ${data[0].product}
                                </td>

                                <td>
                                    <select class="form-control unit" style="text-align: center" name="unit[]" id="unit${index}">
                                    ${units}
                                    </select>
                                    <input type="hidden" value="1" name="cont[]" id="cont${index}" class="form-control cont" style="text-align: center" readonly>
                                </td>

                                <td>
                                    <input type="text" name="price[]" value="${unitprice}" id="price${index}" class="form-control price" style="text-align: center">
                                    <input type="hidden" name="buying[]" value="${data[0].buying}" id="buying${index}" class="form-control buying" style="text-align: center" readonly>
                                </td>

                                <td style="display:flex">
                                    <button type="button" class="btn btn-outline-warning btn-block decrement" id="${index}">
                                    <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" value="1" name="qty[]" id="qty${index}" class="form-control qty" style="text-align: center;" required>
                                    <button type="button" class="btn btn-outline-success btn-block increment" id="increment${index}">
                                    <i class="fas fa-plus"></i>
                                    </button>
                                </td>

                                <td>
                                    <input type="text" name="amount[]" value="${unitprice}" id="amount${index}" class="form-control amount" style="text-align: center" readonly>
                                </td>

                                <td>
                                    <button type="button" id="${index}" class="btn btn-outline-danger removeRow">
                                    <i class="fas fa-trash-alt"></i>
                                    </button>
                                </td>
                                </tr>
                                `;

                            $("#tbody").after(tr);
                            index++;
                            total();

                            $("#search").val("");
                            $("#search").focus();
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                    }
                });

                isFunctionRunning = false;
            });

            $("#search").on("keyup", function() {
                if (isFunctionRunning) {
                    return; // Skip execution if a function is already running
                }

                isFunctionRunning = true;

                let ujumbe = "No suggestions..";
                let query = $(this).val();
                let locationId = $("#location").val();

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': locationId,
                    },
                    success: function(response) {
                        $("#results").empty();
                        ajaxResults = response;
                        console.log(ajaxResults);
                        // If somthing is typed.
                        if (query != "") {
                            // If ajax response returns nothing.
                            if (ajaxResults.length === 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }
                            // If ajax response returns sothing.
                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    [i] + '" >' +
                                    ajaxResults[i].product + ' | ' +
                                    ajaxResults[i].stock[0]
                                    .qty + ' ' + ajaxResults[i].unit[0].unit.name +
                                    '</button></li>');
                            }
                        }
                    }
                });

                isFunctionRunning = false;
            });

            $(document).on("click", ".items", function() {
                let id = $(this).prop("id");
                let categoryName = ajaxResults[id].category ? ajaxResults[id].category.name : 'product';
                let availableQty = ajaxResults[id].stock[0].qty;

                // Check if the product is a service.
                if (availableQty <= 0 && categoryName != "Service") {
                    Swal.fire({
                        icon: 'error',
                        title: 'Out of stock',
                        text: ajaxResults[id].product + ' is out of stock',
                        showCloseButton: true
                    })
                } else {
                    let product = $(this).html();
                    let units;
                    let unitprice;
                    let profit;

                    $("#list").fadeOut("slow");

                    // Loop through the assigned units relation.
                    for (var i = 0; i < ajaxResults[id].unit.length; i++) {

                        unitprice = ajaxResults[id].unit[0].selling;

                        // Format the value using the format() method
                        unitprice = formatter.format(unitprice);

                        units = units + '<option value="' + ajaxResults[id].unit[i].unit.id + '">' +
                            ajaxResults[id].unit[i].unit.name + '</option>';
                    }

                    let tr = `
                    <tr id="tr${index}">
                        <td style="text-align: center;">
                            <input type="hidden" name="id[]" value="${ajaxResults[id].id}" id="id${index}" class="form-control id" readonly>
                            <input type="hidden" name="area[]" value="${ajaxResults[id].location_id}" id="area${index}" class="form-control area" readonly>
                            <input type="hidden" name="productQty[]" value="${availableQty}" id="productQty${index}" class="form-control productQty" readonly>
                            <input type="hidden" name="category[]" value="${categoryName}" id="category${index}" class="form-control category" readonly>
                            ${ajaxResults[id].product}
                        </td>

                        <td>
                            <select class="form-control unit" style="text-align: center" name="unit[]" id="unit${index}">
                                ${units}
                            </select>
                            <input type="hidden" value="1" name="cont[]" id="cont${index}" class="form-control cont" style="text-align: center">
                        </td>

                        <td>
                            <input type="text" name="price[]" value="${unitprice}" id="price${index}" class="form-control price" style="text-align: center">
                            <input type="hidden" name="buying[]" value="${ajaxResults[id].buying}" id="buying${index}" class="form-control buying" style="text-align: center" readonly>
                        </td>

                        <td style="display:flex">
                            <button type="button" class="btn btn-outline-warning btn-block decrement" id="${index}">
                                <i class="fas fa-minus"></i>
                            </button>
                            <input type="text" value="1" name="qty[]" id="qty${index}" class="form-control qty" style="text-align: center;" required>
                            <button type="button" class="btn btn-outline-success btn-block increment" id="increment${index}">
                                <i class="fas fa-plus"></i>
                            </button>
                        </td>

                        <td>
                            <input type="text" name="amount[]" value="${unitprice}" id="amount${index}" class="form-control amount" style="text-align: center" readonly>
                        </td>

                        <td>
                            <button type="button" class="btn btn-outline-danger removeRow" id="${index}">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </td>
                    </tr>`;

                    $("#tbody").after(tr);

                    index++; //Increment the index.

                    total(); // Call total function.

                    $("#search").val(""); //Clear the search field.
                    $("#search").focus(); // Put the cursor in the search field.
                }
            });

            $(document).on("click", ".removeRow", function() {
                var id = $(this).prop("id");
                $("#tr" + id).remove();

                total(); // Call total function.

                $("#search").val("");
                $("#search").focus();
            });

            $(document).on("click", ".increment", function() {
                let id = $(this).attr("id").replace("increment", "");
                let qtyInput = $("#qty" + id);
                let productQtyInput = $("#productQty" + id);
                let categoryCheck = $("#category" + id).val();
                let qty = parseFloat(qtyInput.val());
                let productQty = parseFloat(productQtyInput.val());

                // Only call the warning if category is NOT 'service'
                if (categoryCheck != 'Service') {
                    // Call the warning function to check if qty exceeds productQty
                    if (showLimitedCapacityWarning(qty, productQty, qtyInput)) {
                        return; // Stop further execution if limit is exceeded
                    }
                }

                // If limit is not exceeded, proceed with increment
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            function showLimitedCapacityWarning(qty, productQty, qtyInput) {
                if (productQty <= qty) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Limited capacity warning',
                        text: 'Exceeded available quantity!',
                        showCloseButton: true
                    });

                    // Reset the quantity to 1
                    qtyInput.val(1);

                    return true; // Signal to stop further execution
                }
                return false; // Allow further execution if within limit
            }

            $(document).on("click", ".decrement", function() {
                let id = $(this).prop("id").replace("decrement", "");
                let qtyInput = $("#qty" + id);
                let qty = parseFloat(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                let qtyInput = $("#qty" + id);
                let qty = parseFloat(qtyInput.val());
                let buyingInput = $("#buying" + id);
                let priceInput = $("#price" + id);
                let cont = $("#cont" + id).val();

                let price = parseFloat(priceInput.val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let buying = parseFloat(buyingInput.val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                let amountInput = $("#amount" + id);
                let amount = qty * price;

                amountInput.val(formatter.format(amount)); // Format the value using the format() method

                total(); // Call the total function

                $("#search").val("");
                $("#search").focus();
            }

            $(document).on("keyup", ".qty", function() {
                let qtyInput = $(this);
                let qty = parseFloat(qtyInput.val());
                let id = qtyInput.prop("id").replace("qty", "");
                let categoryCheck = $("#category" + id).val();

                // Assuming available quantity is stored in an element with ID "productQty" + id
                let productQty = parseFloat($("#productQty" + id).val());

                // Only call the warning if category is NOT 'service'
                if (categoryCheck != 'Service') {
                    // Call the warning function to check if qty exceeds productQty
                    if (showLimitedCapacityWarning(qty, productQty, qtyInput)) {
                        return; // Stop further execution if limit is exceeded
                    }
                }
                let price = parseFloat($("#price" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let cont = $("#cont" + id).val();
                let amount = price * qty;

                $("#amount" + id).val(formatter.format(amount));

                total();
            });

            function total() {
                let amount = 0;

                // Calculate the total amount by adding up all the amounts in each row of the sale table
                $(".amount").each(function() {
                    amount += parseFloat($(this).val().replace(/,/g, ''),
                        10); // Remove commas and parse as base 10
                });

                amount = formatter.format(amount); // Format the value using the format() method);

                $("#total").val(amount); // Put the total in the total field
            }

            $(document).on("change", ".unit", function() {
                let unitId = $(this).val();
                let id = $(this).prop("id").replace("unit", "");
                let productId = $("#id" + id).val();
                let qty = $("#qty" + id).val();
                let locationId = $("#location").val();

                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10
                let selling = parseFloat($("#price" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                console.log(productId);

                $.ajax({
                    url: "{{ route('unit.details') }}",
                    method: "get",
                    data: {
                        'unitId': unitId,
                        'productId': productId,
                        'locationId': locationId,
                    },

                    success: function(data) {
                        console.log(data.unit_cont);
                        $("#cont" + id).val(data.unit_cont);
                        $("#price" + id).val(formatter.format(data
                            .selling)); // Remove commas and parse as base 10
                        $("#amount" + id).val(formatter.format(data.selling *
                            qty)); // Remove commas and parse as base 10

                        total();

                        $("#search").val("");
                        $("#search").focus();
                    }
                });
            });

            $(document).on("keyup", ".price", function() {
                let id = $(this).prop("id").replace("price", ""); // Remove "price" from the ID

                let price = $(this).val() ? parseFloat($(this).val().replace(/,/g, ''), 10) :
                    0; // Remove commas and parse as base 10

                $("#price" + id).val(formatter.format(price)); // Remove commas and parse as base 10

                let buying = parseFloat($("#buying" + id).val().replace(/,/g, ''),
                    10); // Remove commas and parse as base 10

                let qty = $("#qty" + id).val();
                let cont = $("#cont" + id).val();

                $("#amount" + id).val(formatter.format(price * qty)); // Remove commas and parse as base 10

                total();
            });
        });
    </script>
@endsection
@endsection
