<!DOCTYPE html>
{{--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only. --}}

<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}"> <!-- Useful for AJAX requests -->
    <title>{{ config('app.name') }}</title>
    {{-- Google Font: Source Sans Pro --}}
    <link rel="stylesheet" href="{{ asset('fonts/font.css') }}">
    {{-- Font Awesome Icons --}}
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/fontawesome.min.css') }}">
    {{-- Theme style --}}
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
    {{-- Sweet Alert --}}
    <link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css') }}">
    {{-- DataTable --}}
    <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- JQVMap -->
    <link rel="stylesheet" href="{{ asset('plugins/jqvmap/jqvmap.min.css') }}">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="{{ asset('plugins/daterangepicker/daterangepicker.css') }}">
    <!-- summernote -->
    <link rel="stylesheet" href="{{ asset('plugins/summernote/summernote-bs4.min.css') }}">
    <!-- FullCalendar CSS -->
    <link rel="stylesheet" href="{{ asset('plugins/fullcalendar/main.min.css') }}">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: white;
        }
    </style>
</head>

{{-- <body class="hold-transition dark-mode sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed"> --}}

<body class="hold-transition sidebar-mini layout-fixed">

    @php
        $businessName = null;
        $locationDetails = processLocationDetails();
        $userSellingLocation = $locationDetails['userSellingLocation'];
        $sellingCount = $locationDetails['sellingCount'];
        if ($userSellingLocation != 'all') {
            $profileData = App\Models\BusinessProfile::where('selling_id', $userSellingLocation)
                ->with('selling.location')
                ->first();
            $businessName = $profileData->selling->location->name ?? 'Business';
        } else {
            $mainData = App\Models\main::with('location')->first();
            $businessName = $mainData->location->name;
        }
    @endphp
    <div class="wrapper">
        {{-- Horizontal Navbar --}}
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">

            <!-- Menu za juu kushoto -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <h4><a href="#" class="nav-link">
                            <strong> {{ $businessName }} </strong>
                        </a></h4>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    {{-- Add margin-top for spacing --}}
                    <div style="margin-left: 10px;">
                        @php
                            $remainingTime = getFormattedLicenseRemainingTime();
                        @endphp

                        @if ($remainingTime && $remainingTime !== 'License expired')
                            <div class="d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>License Remaining:</strong> {{ $remainingTime }}
                                </span>
                            </div>
                        @elseif ($remainingTime === 'License expired')
                            <div class="alert alert-danger d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>HOSTING & LICENSE HAS EXPIRED!</strong>
                                </span>
                            </div>
                        @else
                            <div class="alert alert-warning d-flex align-items-center mb-0" role="alert"
                                style="font-size: 1rem; padding: 0.5rem 1rem;">
                                <span>
                                    <strong>No license dat a found.</strong>
                                </span>
                            </div>
                        @endif
                    </div>
                </li>
            </ul>

            <!-- Menu za juu upande kulia ppur-->
            <ul class="navbar-nav ml-auto">

                <!-- Navbar Search -->
                <li class="nav-item">
                    <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                        <i class="fas fa-search"></i>
                    </a>
                    <div class="navbar-search-block">
                        <form class="form-inline">
                            <div class="input-group input-group-sm">
                                <input class="form-control form-control-navbar" type="search" placeholder="Search"
                                    aria-label="Search">
                                <div class="input-group-append">
                                    <button class="btn btn-navbar" type="submit">
                                        <i class="fas fa-search"></i>
                                    </button>
                                    <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a href="#" class="nav-link"><i class="fa fa-phone fa-lg" aria-hidden="true"></i> (+255 757
                        290 359) For support</a>
                </li>

                <li class="nav-item d-none d-sm-inline-block">
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                        class="nav-link">
                        <i class="fa fa-sign-out" aria-hidden="true"></i>
                        Logout
                    </a>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        {{ csrf_field() }}
                    </form>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                        <i class="fas fa-expand-arrows-alt"></i>
                    </a>
                </li>
            </ul>

        </nav>
        {{-- /Horizontal Navbar --}}

        {{--  vertical menues --}}
        <aside class="main-sidebar sidebar-dark-primary elevation-4">

            {{--  Brand Logo (Business logo) --}}
            <a href="#" class="brand-link">
                <img src="{{ asset('dist/img/logo.ico') }}" alt="DukaMax Logo"
                    class="brand-image img-circle elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light">Duka | Max</span>
            </a>

            {{--  Sidebar --}}
            <div class="sidebar">

                {{-- Sidebar user panel (User details) --}}
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <img src="{{ asset('dist/img/user.jpg') }}" class="img-circle elevation-2" alt="User Image">
                    </div>
                    <div class="info">
                        <a href="#" class="d-block">{{ auth()->user()->name ?? '' }}</a>
                    </div>
                </div>

                {{-- SidebarSearch Form (Search field) --}}
                <div class="form-inline">
                    <div class="input-group" data-widget="sidebar-search">
                        <input class="form-control form-control-sidebar" type="search" placeholder="Search"
                            aria-label="Search">
                        <div class="input-group-append">
                            <button class="btn btn-sidebar">
                                <i class="fas fa-search fa-fw"></i>
                            </button>
                        </div>
                    </div>
                </div>

                {{--  Sidebar Menu (nav menues)  --}}
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="true">

                        <li class="nav-item">
                            <a href="{{ route('home') }}" class="nav-link">
                                <i class="fa-solid fa-gauge"></i>
                                <p>
                                    Dashboard
                                </p>
                            </a>
                        </li>

                        @can('sales')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                    <p>
                                        Sale
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('sale.index', ['id' => 0, 'status' => 'sale']) }}"
                                            class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Post sale</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('sales.return.view.index') }}" class="nav-link">
                                            <i class="fa-solid fa-arrow-rotate-left"></i>
                                            <p>Sales return</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('profoma.invoice.view') }}" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Profoma invoice</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('sales.reciept') }}" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Reciepts & delivery</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endcan

                        @can('purchases')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-cart-arrow-down"></i>
                                    <p>
                                        Purchase
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">
                                        <a href="{{ route('purchase.view', ['id' => 0, 'status' => 'purchase']) }}"
                                            class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Post purchase</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('purchase.return.view') }}" class="nav-link">
                                            <i class="fa-solid fa-arrow-rotate-right"></i>
                                            <p>Purchase return</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('supplier.index') }}" class="nav-link">
                                            <i class="fa-solid fa-people-group"></i>
                                            <p>Suppleir</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('purchase.order.view') }}" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Purchase order</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endcan

                        @can('games')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-clipboard-list"></i>
                                    <p>
                                        Customer Order
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('customer.order.index') }}" class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Orders</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('post.expense.index', 1) }}" class="nav-link">
                                            <i class="fa-solid fa-dollar"></i>
                                            <p>Expense</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('customer.order.profit.and.loss') }}" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Order P & L</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endcan

                        @can('games')
                            <li class="nav-item">
                                <a href="{{ route('game.index') }}" class="nav-link">
                                    <i class="fa-solid fa-gamepad"></i>
                                    <p>Games</p>
                                </a>
                            </li>
                        @endcan

                        @can('expenses')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-dollar-sign"></i>
                                    <p>
                                        Expense
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('post.expense.index', 2) }}" class="nav-link">
                                            <i class="fa-solid fa-dollar-sign"></i>
                                            <p>Post Expense</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('expense.category.index') }}" class="nav-link">
                                            <i class="fa-solid fa-tags"></i>
                                            <p>Expense Category</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endcan

                        @can('vehicles')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-truck"></i>
                                    <p>
                                        Vehicle
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('vehicle.index') }}" class="nav-link">
                                            <i class="fa-solid fa-car"></i>
                                            <p>Vehicle</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('driver.index') }}" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Drivers</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('salesmen.index') }}" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Sales men</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('load.vehicle.view') }}" class="nav-link">
                                            <i class="fa-solid fa-truck-loading"></i>
                                            <p>Load vehicle</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('loaded.vehicle') }}" class="nav-link">
                                            <i class="fa-solid fa-truck"></i>
                                            <p>Loaded vehicles</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('unload.vehicle.view') }}" class="nav-link">
                                            <i class="fa-solid fa-truck-loading"></i>
                                            <p>Unload Vehicle</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endcan

                        @can('stock')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-brands fa-shopify fa-lg"></i>
                                    <p>
                                        Stock
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('unit.index') }}" class="nav-link">
                                            <i class="fa-solid fa-ruler"></i>
                                            <p>Units</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('product.category.index') }}" class="nav-link">
                                            <i class="fa-solid fa-tags"></i>
                                            <p>Category</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('product.index') }}" class="nav-link">
                                            <i class="fa-solid fa-plus"></i>
                                            <p>New product</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('update.product.view') }}" class="nav-link">
                                            <i class="fa-solid fa-pencil"></i>
                                            <p>Update</p>
                                        </a>
                                    </li>

                                    @can('delete')
                                        <li class="nav-item">
                                            <a href="{{ route('delete.product.view') }}" class="nav-link">
                                                <i class="fa-solid fa-trash"></i>
                                                <p>Delete</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('damage_stock')
                                        <li class="nav-item">
                                            <a href="{{ route('damage.stock.view') }}" class="nav-link">
                                                <i class="fa-solid fa-heart-broken"></i>
                                                <p>Damages</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('stock_transfer')
                                        <li class="nav-item">
                                            <a href="{{ route('stock.transfer.view') }}" class="nav-link">
                                                <i class="fa-solid fa-exchange"></i>
                                                <p>Transfer</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('stocklist')
                                        <li class="nav-item">
                                            <a href="{{ route('stock.list.view') }}" class="nav-link">
                                                <i class="fa-solid fa-list"></i>
                                                <p>Stock list</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('pricelist')
                                        <li class="nav-item">
                                            <a href="{{ route('price.list.view') }}" class="nav-link">
                                                <i class="fa-solid fa-list"></i>
                                                <p>Price list</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('services')
                                        <li class="nav-item">
                                            <a href="{{ route('service.index') }}" class="nav-link">
                                                <i class="fa-solid fa-wrench"></i>
                                                <p>Services</p>
                                            </a>
                                        </li>
                                    @endcan

                                    @can('stock_tacking')
                                        <li class="nav-item">
                                            <a href="{{ route('stock.tacking.view') }}" class="nav-link">
                                                <i class="fa-solid fa-clock"></i>
                                                <p>Stock tacking</p>
                                            </a>
                                        </li>
                                    @endcan

                                    <li class="nav-item">
                                        <a href="{{ route('requisitions') }}" class="nav-link">
                                            <i class="fa-solid fa-file-lines"></i>
                                            <p>Requisition</p>
                                        </a>
                                    </li>

                                    @can('barcode')
                                        <li class="nav-item">
                                            <a href="{{ route('barcode.view') }}" class="nav-link">
                                                <i class="fa-solid fa-barcode"></i>
                                                <p>Barcode</p>
                                            </a>
                                        </li>
                                    @endcan

                                    <li class="nav-item">
                                        <a href="{{ route('stock.reset.view') }}" class="nav-link">
                                            <i class="fa-solid fa-rotate-right"></i>
                                            <p>Stock reset</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endcan

                        @can('kitchen')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa fa-bowl-food"></i>
                                    <p>
                                        Bar & resturant
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    @can('waiters')
                                        <li class="nav-item">

                                            <a href="{{ route('waiters.index') }}" class="nav-link">
                                                <i class="fas fa-user-tie nav-icon"></i>
                                                <p>Waiters</p>
                                            </a>

                                        </li>
                                    @endcan

                                    @can('tables')
                                        <li class="nav-item">

                                            <a href="{{ route('table.index') }}" class="nav-link">
                                                <i class="fas fa-table nav-icon"></i>
                                                <p>Table no</p>
                                            </a>

                                        </li>
                                    @endcan

                                    @can('ingredients')
                                        <li class="nav-item">
                                            <a href="{{ route('ingredient.index') }}" class="nav-link">
                                                <i class="fas fa-pepper-hot nav-icon"></i>
                                                <p>Ingredients</p>
                                            </a>
                                        </li>
                                    @endcan

                                    <li class="nav-item">
                                        <a href="{{ route('menu.index') }}" class="nav-link">
                                            <i class="fas fa-hamburger nav-icon"></i>
                                            <p>Food</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('incomming.table.reservation') }}" class="nav-link">
                                            <i class="fas fa-calendar-check nav-icon"></i>
                                            <p>Reservation</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('drink.index') }}" class="nav-link">
                                            <i class="fas fa-champagne-glasses nav-icon"></i>
                                            <p>Drinks</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('place.oder.index', 'start') }}" class="nav-link">
                                            <i class="fas fa-shopping-cart nav-icon"></i>
                                            <p>Place oder</p>
                                        </a>
                                    </li>

                                    @can('cancel_bills')
                                        <li class="nav-item">

                                            <a href="{{ route('cancel.order.view') }}" class="nav-link">
                                                <i class="fas fa-window-close nav-icon"></i>
                                                <p>Cancel oder</p>
                                            </a>

                                        </li>
                                    @endcan

                                    <li class="nav-item">
                                        <a href="{{ route('waiters.bill.view') }}" class="nav-link">
                                            <i class="fas fa-coins nav-icon"></i>
                                            <p>Waiters & Tables bills</p>
                                        </a>
                                    </li>

                                    @can('pay_bills')
                                        <li class="nav-item">
                                            <a href="{{ route('pay.bill.view') }}" class="nav-link">
                                                <i class="fas fa-file-invoice-dollar nav-icon"></i>
                                                <p>Pay bills</p>
                                            </a>
                                        </li>
                                    @endcan

                                </ul>
                            </li>
                        @endcan

                        @can('accomodation')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-hotel"></i>
                                    <p>
                                        Accomodation
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">

                                        <a href="{{ route('rooms.index') }}" class="nav-link">
                                            <i class="fas fa-door-open nav-icon"></i>
                                            <p>Rooms</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="{{ route('booking.index') }}" class="nav-link">
                                            <i class="fas fa-clipboard-list nav-icon"></i>
                                            <p>Booking</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="{{ route('upcoming.bookings') }}" class="nav-link">
                                            <i class="fas fa-calendar-plus nav-icon"></i>
                                            <p>Upcomming bookings</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('inside.customers', 'start') }}" class="nav-link">
                                            <i class="fas fa-users nav-icon"></i>
                                            <p>In house geusts</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endcan

                        @can('events')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-calendar-days"></i>
                                    <p>
                                        Events management
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">

                                        <a href="{{ route('event.index') }}" class="nav-link">
                                            <i class="fas fa-calendar-day nav-icon"></i>
                                            <p>Events</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="{{ route('venue.index') }}" class="nav-link">
                                            <i class="fas fa-map-marker-alt nav-icon"></i>
                                            <p>Venue</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="{{ route('venue.booking.index') }}" class="nav-link">
                                            <i class="fas fa-calendar-check nav-icon"></i>
                                            <p>Bookings</p>
                                        </a>

                                    <li class="nav-item">

                                        <a href="{{ route('upcoming.events') }}" class="nav-link">
                                            <i class="fas fa-calendar-plus nav-icon"></i>
                                            <p>Upcomming events</p>
                                        </a>

                                    </li>

                                    <li class="nav-item">

                                        <a href="{{ route('inprogress.events') }}" class="nav-link">
                                            <i class="fas fa-hourglass-half nav-icon"></i>
                                            <p> In progeress events</p>
                                        </a>

                                    </li>

                                </ul>
                            </li>
                        @endcan

                        @can('locations')
                            <li class="nav-item">
                                <a href="{{ route('location.index') }}" class="nav-link">
                                    <i class="fa-solid fa-location-crosshairs"></i>
                                    <p>Location</p>
                                </a>
                            </li>
                        @endcan

                        @can('customers')
                            <li class="nav-item">
                                <a href="{{ route('customer.index') }}" class="nav-link">
                                    <i class="fa-solid fa-user"></i>
                                    <p>Customer</p>
                                </a>
                            </li>
                        @endcan

                        @can('accounts')
                            <li class="nav-item">
                                <a href="{{ route('account.index') }}" class="nav-link">
                                    <i class="fa-solid fa-money-check"></i>
                                    <p>Accounts</p>
                                </a>

                            </li>
                        @endcan

                        @can('assets')
                            <li class="nav-item">
                                <a href="{{ route('asset.index') }}" class="nav-link">
                                    <i class="fa-solid fa-chart-simple"></i>
                                    <p>Assets</p>
                                </a>
                            </li>
                        @endcan

                        @can('loan')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-landmark"></i>
                                    <p>
                                        Loan
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('creditor.index') }}" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Creditor</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('debtor.index') }}" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>Debtors</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('recieved.loan.index') }}" class="nav-link">
                                            <i class="fa-solid fa-file-invoice"></i>
                                            <p>Loan Details </p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endcan

                        @can('production')
                            <li class="nav-item">
                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-industry fa-lg"></i>
                                    <p>
                                        Production
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">
                                    <li class="nav-item">
                                        <a href="{{ route('production.order') }}" class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Place Order</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('production.order.progress', 1) }}" class="nav-link">
                                            <i class="fa-solid fa-clipboard-check"></i>
                                            <p>Order Progress</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('dispatch') }}" class="nav-link">
                                            <i class="fa-solid fa-truck"></i>
                                            <p>Dispatch</p>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        @endcan

                        <li class="nav-item">

                            <a href="#" class="nav-link">
                                <i class="fa-solid fa-chart-column"></i>
                                <p>
                                    Reports
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">

                                @can('sales_report')
                                    <li class="nav-item">
                                        <a href="{{ route('sales.report') }}" class="nav-link">
                                            <i class="fa-solid fa-cart-shopping"></i>
                                            <p>Sales</p>
                                        </a>
                                    </li>
                                @endcan

                                @can('purchases_report')
                                    <li class="nav-item">
                                        <a href="{{ route('purchases.report.view') }}" class="nav-link">
                                            <i class="fa-solid fa-cart-arrow-down"></i>
                                            <p>Purchase</p>
                                        </a>
                                    </li>
                                @endcan

                                @can('expenses_report')
                                    <li class="nav-item">
                                        <a href="{{ route('expense.report.view') }}" class="nav-link">
                                            <i class="fa-solid fa-money-bill-wave"></i>
                                            <p>Expense</p>
                                        </a>
                                    </li>
                                @endcan

                                <li class="nav-item">
                                    <a href="{{ route('customer.debts.report') }}" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Customer Debts</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="{{ route('supplier.debts.report') }}" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Supplier Debts</p>
                                    </a>
                                </li>

                                @can('stock_report')
                                    <li class="nav-item">
                                        <a href="{{ route('stock.report') }}" class="nav-link">
                                            <i class="fa-solid fa-box"></i>
                                            <p>Stock</p>
                                        </a>
                                    </li>
                                @endcan

                                @can('vehicle_report')
                                    <li class="nav-item">
                                        <a href="{{ route('vehicles.report') }}" class="nav-link">
                                            <i class="fa-solid fa-car"></i>
                                            <p>Vehicles</p>
                                        </a>
                                    </li>
                                @endcan

                                <li class="nav-item">
                                    <a href="{{ route('production.report') }}" class="nav-link">
                                        <i class="fa-solid fa-industry fa-lg"></i>
                                        <p>Production</p>
                                    </a>
                                </li>

                                @can('cash_report')
                                    <li class="nav-item">
                                        <a href="{{ route('cash.movement.view') }}" class="nav-link">
                                            <i class="fa-solid fa-coins"></i>
                                            <p>Cash</p>
                                        </a>
                                    </li>
                                @endcan

                                @can('income_report')
                                    <li class="nav-item">
                                        <a href="{{ route('income.report') }}" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Profit & Loss</p>
                                        </a>
                                    </li>
                                @endcan

                                @can('income_report')
                                    <li class="nav-item">
                                        <a href="{{ route('accounting.overview') }}" class="nav-link">
                                            <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                            <p>Balance Sheet</p>
                                        </a>
                                    </li>
                                @endcan

                                <li class="nav-item">
                                    <a href="{{ route('settlement.report') }}" class="nav-link">
                                        <i class="fa-solid fa-scale-unbalanced-flip"></i>
                                        <p>Settlement Report</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="fa-solid fa-address-card"></i>
                                <p>
                                    My Business
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>

                            <ul class="nav nav-treeview">
                                <li class="nav-item">
                                    <a href="{{ route('profile.view') }}" class="nav-link">
                                        <i class="fa-solid fa-user"></i>
                                        <p>Profile</p>
                                    </a>
                                </li>

                                @can('ip_setting')
                                    <li class="nav-item">
                                        <a href="{{ route('ip.view') }}" class="nav-link">
                                            <i class="fa-solid fa-globe-europe"></i>
                                            <p>IP Setting</p>
                                        </a>
                                    </li>
                                @endcan

                                <li class="nav-item">
                                    <a href="{{ route('subscription.index') }}" class="nav-link">
                                        <i class="fa-solid fa-calendar-plus"></i>
                                        <p>Renew Subscription</p>
                                    </a>
                                </li>

                                <li class="nav-item">
                                    <a href="{{ route('pricing') }}" class="nav-link">
                                        <i class="fa-solid fa-money-bill-wave"></i>
                                        <p>Pricing</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        @role('Admin')
                            <li class="nav-item">

                                <a href="#" class="nav-link">
                                    <i class="fa-solid fa-users"></i>
                                    <p>
                                        Users
                                        <i class="right fas fa-angle-left"></i>
                                    </p>
                                </a>

                                <ul class="nav nav-treeview">

                                    <li class="nav-item">
                                        <a href="{{ route('users.view') }}" class="nav-link">
                                            <i class="fa-solid fa-user"></i>
                                            <p>System Users</p>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a href="{{ route('user.role.index') }}" class="nav-link">
                                            <i class="fa-solid fa-circle-user"></i>
                                            <p>User Rolels</p>
                                        </a>
                                    </li>

                                </ul>
                            </li>
                        @endrole

                    </ul>
                </nav>
                {{-- /.sidebar-menu --}}

            </div>
            {{-- /.sidebar --}}
        </aside>

        {{-- Page content --}}
        <div class="content-wrapper">

            @include('patial.loading-spinner')

            {{-- Content Header (Page header) --}}
            <div class="content-header">
                <center>
                    {{-- <h5 class="text-black-50">Role Permissions</h5> --}}

                    {{-- Loading indicator --}}
                    <div id="loading-indicator" class="spinner">
                        <div class="rect1"></div>
                        <div class="rect2"></div>
                        <div class="rect3"></div>
                        <div class="rect4"></div>
                        <div class="rect5"></div>
                    </div>
                </center>
            </div>
            {{-- /.content-header --}}

            {{-- General errors at the top --}}
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @yield('content')

        </div>
        {{-- /.content-wrapper --}}

        {{-- Control Sidebar --}}
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
            <div class="p-3">
                <h5>Title</h5>
                <p>Sidebar content</p>
            </div>
        </aside>
        {{-- /.control-sidebar --}}

        {{-- Main Footer  --}}
        <footer class="main-footer hide-on-print">
            <!-- To the right -->
            <div class="float-right d-none d-sm-inline">
                <span style="font-size: 1rem; color: #28a745; font-weight: 500;">
                    Crafted with <i class="fa fa-heart text-danger"></i> by
                    <span style="color: #007bff;">Burton</span>
                    <span class="badge bg-dark" style="font-size: 0.9rem;">#ITMan</span>
                    <a href="https://wa.me/+255786373296" class="badge bg-success" target="_blank"
                        style="margin-left: 8px; text-decoration: none;">
                        <i class="fab fa-whatsapp"></i> WhatsApp
                    </a>
                </span>
            </div>
            <!-- Default to the left -->
            <strong>Copyright &copy;
                <script>
                    document.write(new Date().getFullYear())
                </script> <a href="https://www.dukamax.online" target="_blank">dukamax.online</a>.
            </strong> All rights
            reserved.
        </footer>
    </div>
    {{-- ./wrapper --}}

    {{-- REQUIRED SCRIPTS --}}

    {{-- jQuery --}}
    <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button)
    </script>
    {{-- Bootstrap 4 --}}
    <script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- ChartJS -->
    <script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>
    <!-- Sparkline -->
    <script src="{{ asset('plugins/sparklines/sparkline.js') }}"></script>
    <!-- JQVMap -->
    <script src="{{ asset('plugins/jqvmap/jquery.vmap.min.js') }}"></script>
    <script src="{{ asset('plugins/jqvmap/maps/jquery.vmap.usa.js') }}"></script>
    <!-- jQuery Knob Chart -->
    <script src="{{ asset('plugins/jquery-knob/jquery.knob.min.js') }}"></script>
    <!-- daterangepicker -->
    <script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('plugins/daterangepicker/daterangepicker.js') }}"></script>
    <!-- Tempusdominus Bootstrap 4 -->
    <script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
    <!-- Summernote -->
    <script src="{{ asset('plugins/summernote/summernote-bs4.min.js') }}"></script>
    <!-- overlayScrollbars -->
    <script src="{{ asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script>
    <!-- FullCalendar JS -->
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    {{-- Sweet Alert --}}
    <script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js') }}"></script>
    <!-- Toastr -->
    <script src="{{ asset('plugins/toastr/toastr.min.js') }}"></script>
    {{-- DataTable --}}
    <script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>
    <script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('plugins/pdfmake/vfs_fonts.js') }}"></script>
    {{-- AdminLTE App --}}
    <script src="{{ asset('dist/js/adminlte.min.js') }}"></script>

    {{-- PDF Links --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>


    <script>
        function showSpinner() {
            // Show spinner to be called on form submission
            document.querySelector('.spinner').style.display = 'block';
        }

        window.addEventListener('load', function() {
            // hide the spinner after the page is loaded
            document.querySelector('.spinner').style.display = 'none';
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $("#data-table").DataTable();
    </script>


    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                html: `<div style="font-size:1.2rem; color:#155724; font-weight:500;">
                            {{ session()->get('success') }}
                        </div>`,
                background: '#e6ffed',
                showConfirmButton: false,
                timer: 2500,
                timerProgressBar: true,
                position: 'top-end',
                toast: true,
                customClass: {
                    popup: 'swal2-border-radius'
                }
            });
        </script>
    @endif

    @if (session()->has('error'))
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Oops!',
                html: `<div style="font-size:1.2rem; color:#721c24; font-weight:500;">
                        {{ session()->get('error') }}
                    </div>`,
                background: '#ffeaea',
                showConfirmButton: false,
                timer: 4000,
                timerProgressBar: true,
                position: 'top-end',
                toast: true,
                customClass: {
                    popup: 'swal2-border-radius'
                }
            });
        </script>
    @endif

    @yield('scripts')
</body>

</html>
