<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'My App')</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Font Awesome 6 CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">

    @stack('styles') {{-- Extra page-specific CSS --}}
</head>

<body>
    <audio id="notifSound" src="{{ asset('dist/sound/notification.mp3') }}" preload="auto"></audio>

    {{-- Common navbar or header can go here --}}
    @includeIf('layouts.navbar')

    <div class="container py-5">
        @yield('content') {{-- Page-specific content --}}
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <!-- SweatAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script src="https://js.pusher.com/7.2/pusher.min.js"></script>
    <script src="{{ asset('js/app.js') }}"></script>
    <audio id="orderSound" src="{{ asset('sounds/notification.mp3') }}" preload="auto"></audio>

    <script>
        Echo.channel('orders')
            .listen('.new-order', (e) => {
                console.log('New Order:', e.order);

                // Play notification sound
                document.getElementById('orderSound').play();

                // Optional: Show a toast or alert
                alert('New Order Received!');
            });
    </script>
    <script>
        window.Echo.channel('orders')
            .listen('.new-order', (e) => {
                console.log(e.message);
                document.getElementById('notifSound').play();
                alert(e.message); // Optional popup
            });
    </script>

    @if (session('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                html: `<div style="font-size:1.2rem; color:#155724; font-weight:500;">
                            {!! session('success') !!}
                        </div>`,
                background: '#e6ffed',
                showConfirmButton: false,
                timer: 2500,
                toast: true,
                position: 'top-end',
            });
        </script>
    @endif

    @if (session('error'))
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Oops!',
                html: `<div style="font-size:1.2rem; color:#721c24; font-weight:500;">
                            {!! session('error') !!}
                        </div>`,
                background: '#ffeaea',
                showConfirmButton: false,
                timer: 4000,
                toast: true,
                position: 'top-end',
            });
        </script>
    @endif

    @stack('scripts') {{-- Extra page-specific scripts --}}
</body>

</html>
