@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">
        {{-- <center>
            <h5 class="text-black-50">Inprogress events</h5>
        </center> --}}
    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div><br />
        @endif

        <div class="card">
            <div class="card-header">

            </div>

            <div class="card-body">

                <table class="table table-stripped" id="customer">
                    <thead>

                        <tr>
                            <th style="width: 5%;"><input type="checkbox" id="checkall"></th>
                            <th style="width: 10%;">S/N</th>
                            <th>Customer</th>
                            <th>Events</th>
                            <th>Venue</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th style="width: 10%;">Action</th>
                        </tr>

                    </thead>

                    @foreach ($bookings as $booking)
                        <tr>
                            <td><input type="checkbox" id="{{ $booking->id }}" class="selected"></td>
                            <td> {{ $loop->index + 1 }}</td>
                            <td>{{ $booking->customer }}</td>
                            <td>{{ $booking->event }}</td>
                            <td>{{ $booking->venue }}</td>
                            <td>{{ $booking->date }}</td>
                            <td> From: {{ $booking->start_time }} - To: {{ $booking->end_time }}</td>
                            <td>

                                {{-- Check-out trigger model --}}

                                <button type="button" class="btn btn-success" data-toggle="modal"
                                    data-target="#edit-{{ $booking->id }}">
                                    Check-out
                                </button>

                                <div class="modal fade" id="edit-{{ $booking->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title">Inprogress Event</h5>
                                                <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('venue.checkout')}}" method="get">
                                                @csrf

                                                <div class="modal-body">

                                                    <label for="date">Date</label>
                                                    <input type="text" value="{{ $booking->date }}" name="date"
                                                        class="form-control" id="date" required readonly>

                                                    <label for="name">Full name</label>
                                                    <input type="text" name="customer" class="form-control"
                                                        id="name" value="{{ $booking->customer }}" required>

                                                    <label for="venue">Venue</label>
                                                    <input type="text" name="venue" value="{{ $booking->venue }}"
                                                        class="form-control" id="venue" readonly required>

                                                    <label for="vprice">Venue price</label>
                                                    <input type="number" name="vprice" value="{{ $booking->vprice }}"
                                                        class="form-control" id="vprice" readonly required>

                                                    <label for="event">Event</label>
                                                    <input type="text" name="event" value="{{ $booking->event }}"
                                                        class="form-control" id="event" readonly required>

                                                    <label for="eprice">Event price</label>
                                                    <input type="number" value="{{ $booking->eprice }}" name="eprice"
                                                        class="form-control" id="eprice" readonly required>

                                                    <label for="total">Total amount</label>
                                                    <input type="number" name="total" value="{{ $booking->total }}"
                                                        class="form-control" id="total" readonly required>

                                                    <label for="discount">Discount</label>
                                                    <input type="number" value="{{ $booking->discount }}" name="discount"
                                                        class="form-control" id="discount" required>

                                                    <label for="net">Net amount</label>
                                                    <input type="number" name="net" value="{{ $booking->net }}"
                                                        class="form-control" id="net" readonly>

                                                    <label for="paid">Paid amount</label>
                                                    <input type="number" value="{{ $booking->paid }}" name="paid"
                                                        class="form-control" id="paid" required readonly>

                                                    <label for="due">Due balance</label>
                                                    <input type="number" value="1" name="due"
                                                        class="form-control" id="due" readonly required>

                                                    <div style="display: none" id="payment">
                                                        <label for="pdue">Pay due amount</label>
                                                        <input type="number" name="pdue" class="form-control"
                                                            id="pdue" required>

                                                        <label for="account">Account</label>
                                                        <select name="account" id="account" class="form-control"
                                                            required>
                                                            <option disabled selected value="">
                                                               Choose account
                                                            </option>
                                                            @foreach ($accounts as $account)
                                                                <option value="{{ $account->name }}">{{ $account->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                    </div>

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="submit" id="button" class="btn btn-primary"
                                                        style="display: none">Check-out</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                            </td>
                        </tr>
                    @endforeach

                    <tfoot>
                        <tr>
                            <th style="width: 40px;"><input type="checkbox" id="checkall"></th>
                            <th style="width: 50px;">S/N</th>
                            <th>Customer</th>
                            <th>Events</th>
                            <th>Venue</th>
                            <th>Date</th>
                            <th>Time</th>

                            <th style="width: 80px;">Action</th>
                        </tr>

                    </tfoot>

                </table>

            </div>
        </div>

    </div>
    {{-- /.content --}}


@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>

        $("#customer").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $('#type1').on("change", function() {
            var change = $(this).val();
            if (change == "storage") {
                $('#sellingdiv').fadeIn("slow");
                $('#selling1').prop("required", true);
            } else {
                $('#sellingdiv').fadeOut("slow");
                $('#selling1').prop("required", false);
            }
        });

        var due = $("#due").val();
        if (due > 0) {
            $("#payment").fadeIn("slow");
            $("#button").fadeIn("slow");
            $("#pdue").attr("required", true);
            $("#account").attr("required", true);
        } else {
            $("#payment").fadeOut("slow");
            $("#button").fadeOut("slow");
            $("#pdue").attr("required", false);
            $("#account").attr("required", false);
        }

        $("#pdue").on("input", function(){
          var amount = $(this).val();
          if(amount == due){
            $("#button").fadeIn("slow");
          }else{
            $("#button").fadeOut("slow");
          }
        });

        $('#type').on("change", function() {
            var change = $(this).val();
            if (change == "storage") {
                $('#selldiv').fadeIn("slow");
                $('#selling').prop("required", true);
            } else {
                $('#selldiv').fadeOut("slow");
                $('#selling').prop("required", false);
            }
        });


        $('#checkall').on('click', function() {

            if ($(this).is(':checked', true)) {
                $(".sub_chk").prop('checked', true);
            } else {
                $(".sub_chk").prop('checked', false);
            }

        });

        $("#deleteall").on("click", function() {
            var selected = [];
            $(".selected:checked").each(function() {
                selected.push($(this).attr("id"));
            });

            if (selected.length == 0) {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Select atleast one item!!',
                });

            } else {

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "",
                            method: "GET",
                            data: {
                                'ids': selected
                            },
                            success: function(data) {
                                window.booking.reload(true);
                            }
                        });

                        $(document).ready(function() {
                            Swal.fire({
                                icon: 'success',
                                title: 'deleted successfully!!',
                                showConfirmButton: false,
                                timer: 2000
                            });
                        });
                    }
                });

            }

        });

        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
