@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete"><i class="fa-solid fa-trash-alt"></i>
                    Delete
                    all</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer">
                    <i class="fa-solid fa-plus"></i> New
                    Ingredients</button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="card-header">
                                <div class="container py-3">
                                    <div class="row g-2 align-items-center">

                                        <!-- Download Excel -->
                                        <div class="col-auto">
                                            <a href="{{ asset('dist/Ingredients.xls') }}" class="btn btn-primary w-100">
                                                <i class="fas fa-file-excel mr-1"></i> Download Excel
                                            </a>
                                        </div>

                                        <!-- Upload Excel Form -->
                                        <div class="col-md-auto">
                                            <form action="{{ route('upload.ingredients.excel') }}" method="POST"
                                                enctype="multipart/form-data"
                                                class="d-flex flex-column flex-md-row align-items-stretch gap-2 was-validated">
                                                @csrf
                                                @method('POST')

                                                <!-- File Input -->
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="file"
                                                            name="file" required onchange="changeFileName(this.files)">
                                                        <label class="custom-file-label" for="file">Choose Excel</label>
                                                    </div>


                                                    <!-- Upload Button -->
                                                    <button type="submit" class="btn btn-success">
                                                        <i class="fa fa-upload mr-1"></i> Upload Excel
                                                    </button>
                                                </div>
                                            </form>
                                        </div>

                                        <!-- Rejected Stock -->
                                        <div class="col-auto">
                                            <a href="#" class="btn btn-danger w-100">
                                                <i class="fa fa-times-circle mr-1"></i> Rejected Stock
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <script>
                                    function changeFileName(files) {
                                        const label = document.querySelector('label[for="file"]');
                                        if (files.length) {
                                            label.textContent = files.length > 1 ? `${files.length} files selected` : files[0].name;
                                        }
                                    }
                                </script>
                            </div>

                            <form action="{{ route('ingredient.store') }}" method="POST" enctype="multipart/form-data"
                                class="was-validated">
                                @csrf
                                @method('POST')

                                <div class="card-body table-responsive">
                                    <table class="table table-striped table-hover table-bordered">
                                        <tbody>
                                            <tr>
                                                <td>
                                                    {{-- <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" name="image" id="image"
                                                                class="custom-file-input"
                                                                onchange="document.getElementById('image-label').innerText = this.files[0].name">
                                                            <label class="custom-file-label" id="image-label"
                                                                for="image">Choose file</label>
                                                        </div>
                                                    </div> --}}
                                                    <select name="category" id="category" class="form-control text-center">
                                                        <option value="">-- Choose Category --</option>
                                                        @foreach ($categories as $category)
                                                            <option value="{{ $category->id }}">--
                                                                {{ $category->name }} --</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td><input type="text" name="name" required class="form-control"
                                                        style="text-align: center" placeholder="Ingredient name"></td>
                                                <td><input type="text" name="buying" required class="form-control"
                                                        style="text-align: center" placeholder="Buying price"></td>
                                            </tr>

                                            <tr>
                                                <td> <select name="unit" id="unit" class="form-control"
                                                        style="text-align: center" required>
                                                        <option disabled selected value="">-- Unit --</option>
                                                        @foreach ($units as $unit)
                                                            <option value="{{ $unit->id }}">-- {{ $unit->name }} --
                                                            </option>
                                                        @endforeach
                                                    </select></td>

                                                <td><input type="text" name="qty" required style="text-align: center"
                                                        class="form-control" placeholder="Available qty"></td>

                                                <td><input type="text" name="minqty" required style="text-align: center"
                                                        class="form-control" placeholder="minimum qty"></td>
                                            </tr>

                                            <tr>
                                                <td><input type="date" name="exp" style="text-align: center"
                                                        class="form-control"></td>
                                                <td> <select name="expnot" id="expnot" class="form-control"
                                                        style="text-align: center">
                                                        <option disabled selected value="">-- Notification --</option>
                                                        <option value="1">-- 1 month --</option>
                                                        <option value="2">-- 2 month --</option>
                                                        <option value="3">-- 3 month --</option>
                                                    </select>
                                                </td>
                                                <td> <select name="location" id="location" class="form-control"
                                                        style="text-align: center" required>
                                                        <option disabled selected value="">-- Choose Location --
                                                        </option>
                                                        @foreach ($sellings as $selling)
                                                            <option value="{{ $selling->location_id }}">
                                                                -- {{ $selling->location->name }} --</option>

                                                            @foreach ($selling->storage as $storage)
                                                                <option value="{{ $storage->location_id }}">
                                                                    -- {{ $storage->location->name }} --</option>
                                                            @endforeach
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="card-footer text-center">
                                    <button class="btn btn-primary"><i class="fa fa-paper-plane"></i>
                                        Register</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <table class="table table-striped table-hover" id="ingredients">
                <thead class="table-dark">
                    <tr>
                        <th style="width: 5%"><input type="checkbox" id="master"></th>
                        <th style="width: 10%">S/N</th>
                        <th>Ingredients</th>
                        <th>Buying</th>
                        <th>QTY</th>
                        <th>Min.L</th>
                        <th>Exp</th>
                        <th>Exp not</th>
                        <th style="width: 15%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($ingredients as $ingredient)
                        <tr>
                            <td><input type="checkbox" class="sub_chk" id="check-{{ $ingredient->id }}"></td>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $ingredient->product }}</td>
                            <td>{{ number_format($ingredient->buying) }}</td>
                            <td>{{ $ingredient->stock[0]->qty }} {{ $ingredient->unit[0]->unit->name }}</td>
                            <td>{{ $ingredient->stock[0]->min_qty ?? 1 }} {{ $ingredient->unit[0]->unit->name }}</td>
                            <td>
                                @if ($ingredient->exp)
                                    {{ $ingredient->exp }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if ($ingredient->exp)
                                    {{ $ingredient->exp_not }} month(s)
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    {{-- Edit button --}}
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#edit-{{ $ingredient->id }}">
                                        <i class="fa-solid fa-pen-to-square"></i> Edit
                                    </button>

                                    {{-- Edit Modal --}}
                                    <div class="modal fade" id="edit-{{ $ingredient->id }}" tabindex="-1"
                                        role="dialog" aria-labelledby="modalLabel{{ $ingredient->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">

                                                <form action="{{ route('ingredient.update', $ingredient->id) }}"
                                                    method="POST" id="ingredient_form_{{ $ingredient->id }}"
                                                    class="was-validated">
                                                    @csrf
                                                    @method('PUT')

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="modalLabel{{ $ingredient->id }}">
                                                            Update {{ $ingredient->product }}'s Details</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <div class="card-body table-responsive">
                                                            <table class="table table-striped table-hover table-bordered">
                                                                <tbody>
                                                                    <tr>
                                                                        <td>
                                                                            <select name="category" id="category"
                                                                                class="form-control text-center">
                                                                                <option value="">-- Choose Category
                                                                                    --</option>
                                                                                @foreach ($categories as $category)
                                                                                    <option value="{{ $category->id }}"
                                                                                        {{ old('category', $ingredient->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                                                                        -- {{ $category->name }} --
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="name" required
                                                                                class="form-control"
                                                                                style="text-align: center"
                                                                                placeholder="Ingredient name"
                                                                                value="{{ old('name', $ingredient->product ?? '') }}">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="buying" required
                                                                                class="form-control"
                                                                                style="text-align: center"
                                                                                placeholder="Buying price"
                                                                                value="{{ old('buying', $ingredient->buying ?? '') }}">
                                                                        </td>
                                                                    </tr>

                                                                    <tr>
                                                                        <td>
                                                                            <select name="unit" id="unit"
                                                                                class="form-control"
                                                                                style="text-align: center" required>
                                                                                <option disabled selected value="">--
                                                                                    Unit --</option>
                                                                                @foreach ($units as $unit)
                                                                                    <option value="{{ $unit->id }}"
                                                                                        {{ old('unit', $ingredient->unit_id ?? ($ingredient->unit[0]->unit->id ?? '')) == $unit->id ? 'selected' : '' }}>
                                                                                        -- {{ $unit->name }} --
                                                                                    </option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>

                                                                        <td>
                                                                            <input type="text" name="qty" required
                                                                                style="text-align: center"
                                                                                class="form-control"
                                                                                placeholder="Available qty"
                                                                                value="{{ old('qty', $ingredient->stock[0]->qty ?? '') }}">
                                                                        </td>

                                                                        <td>
                                                                            <input type="text" name="minqty" required
                                                                                style="text-align: center"
                                                                                class="form-control"
                                                                                placeholder="minimum qty"
                                                                                value="{{ old('minqty', $ingredient->stock[0]->min_qty ?? '') }}">
                                                                        </td>
                                                                    </tr>

                                                                    <tr>
                                                                        <td>
                                                                            <input type="date" name="exp"
                                                                                style="text-align: center"
                                                                                class="form-control"
                                                                                value="{{ old('exp', isset($ingredient->exp) ? \Carbon\Carbon::parse($ingredient->exp)->format('Y-m-d') : '') }}">
                                                                        </td>
                                                                        <td>
                                                                            <select name="expnot" id="expnot"
                                                                                class="form-control"
                                                                                style="text-align: center">
                                                                                <option disabled selected value="">--
                                                                                    Notification --</option>
                                                                                <option value="1"
                                                                                    {{ old('expnot', $ingredient->exp_not ?? '') == 1 ? 'selected' : '' }}>
                                                                                    -- 1 month --
                                                                                </option>
                                                                                <option value="2"
                                                                                    {{ old('expnot', $ingredient->exp_not ?? '') == 2 ? 'selected' : '' }}>
                                                                                    -- 2 month --
                                                                                </option>
                                                                                <option value="3"
                                                                                    {{ old('expnot', $ingredient->exp_not ?? '') == 3 ? 'selected' : '' }}>
                                                                                    -- 3 month --
                                                                                </option>
                                                                            </select>
                                                                        </td>
                                                                        <td>
                                                                            <select name="location" id="location"
                                                                                class="form-control"
                                                                                style="text-align: center" required>
                                                                                <option disabled selected value="">--
                                                                                    Choose Location --</option>
                                                                                @foreach ($sellings as $selling)
                                                                                    <option
                                                                                        value="{{ $selling->location_id }}"
                                                                                        {{ old('location', $ingredient->location_id ?? '') == $selling->location_id ? 'selected' : '' }}>
                                                                                        -- {{ $selling->location->name }}
                                                                                        --
                                                                                    </option>
                                                                                    @foreach ($selling->storage as $storage)
                                                                                        <option
                                                                                            value="{{ $storage->location_id }}"
                                                                                            {{ old('location', $ingredient->location_id ?? '') == $storage->location_id ? 'selected' : '' }}>
                                                                                            --
                                                                                            {{ $storage->location->name }}
                                                                                            --
                                                                                        </option>
                                                                                    @endforeach
                                                                                @endforeach
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary btn-sm"><i
                                                                class="fa fa-paper-plane"></i> Update</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Delete --}}
                                    <form action="{{ route('ingredient.delete', $ingredient->id) }}" method="POST"
                                        style="display: inline;" id="deleteform{{ $ingredient->id }}">
                                        @csrf
                                        @method('DELETE')
                                        <button type="button" class="btn btn-danger btn-sm delete"
                                            data-id="{{ $ingredient->id }}">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#ingredients").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $('#master').on('click', function(e) {
                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }
            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('ingredients.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully.',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).data("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                });
            });
        });
    </script>
@endsection

@endsection
