<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f6f6f6;
        }

        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            background-color: #fff;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 10px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(4),
        .invoice-box table tr td:nth-child(5) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.top table td.title-right {
            text-align: right;
            font-size: 16px;
            vertical-align: bottom;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        .invoice-box .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }

        .invoice-box .footer a {
            color: #337ab7;
            text-decoration: none;
        }

        .invoice-box .amount-due {
            background-color: #e0ebff;
            font-size: 24px;
            padding: 10px;
            text-align: center;
            color: #333;
            font-weight: bold;
        }

        .alert {
            color: #721c24;
            background-color: #f8d7da;
            padding: 10px;
            border: 1px solid #f5c6cb;
            margin-bottom: 20px;
        }
    </style>
</head>

<body id="body">
    <div class="invoice-box">

        {{-- ✅ Flash error --}}
        @if (session('error'))
            <div class="alert">
                {{ session('error') }}
            </div>
        @endif

        <table>
            <tr class="top">
                <td colspan="5">
                    <table>
                        <strong>I N V O I C E</strong>
                        <hr>
                        <tr>
                            <td class="title-left">
                                <p><strong>BILL FROM:</strong><br>
                                    [{{ $businessProfile->selling->location->name }}]<br>
                                    [{{ $businessProfile->address }}]<br>
                                    [{{ $businessProfile->phone }}]<br>
                                    {{ $businessProfile->email ? "[{$businessProfile->email}]" : '' }}</p>
                            </td>

                            <td class="title-right">
                                <p><strong>BILL TO:</strong><br>
                                    @if ($entityType === 'customer' || $entityType === 'supplier')
                                        [{{ $person->name }}]<br>
                                        [{{ $person->address }}]<br>
                                        [{{ $person->phone }}]<br>
                                        {{ $person->email ? "[{$person->email}]" : '' }}
                                    @else
                                        [No details available]
                                    @endif
                                </p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="information">
                <td colspan="5">
                    <table>
                        <tr>
                            <td>
                                <strong>INVOICE NO #</strong><br>{{ rand(10000, 50000) }}
                            </td>
                            <td>
                                <strong>DATE</strong><br>{{ now()->format('m/d/Y') }}
                            </td>
                            <td>
                                <strong>INVOICE DUE DATE</strong><br>{{ now()->addDays(7)->format('m/d/Y') }}
                            </td>
                            <td class="amount-due">
                                <strong>AMOUNT DUE</strong><br>{{ number_format($totalDue) }}
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="heading">
                <td>DATE</td>
                <td>DESCRIPTION</td>
                <td>QUANTITY</td>
                <td>PRICE</td>
                <td>AMOUNT</td>
            </tr>

            {{-- ✅ Correct variable: transactions --}}
            @foreach ($transactions as $transaction)
                <tr style="background: {{ $loop->even ? '#e3eaf6' : '#fff' }};">
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $transaction->product_name ?? ($transaction->product->product ?? 'N/A') }}</td>
                    <td>{{ $transaction->qty ?? 0 }} {{ $transaction->unit_name ?? ($transaction->unit->name ?? '') }}
                    </td>
                    <td>{{ number_format($transaction->price ?? ($transaction->buying ?? 0), 0) }}</td>
                    <td>{{ number_format($transaction->amount ?? ($transaction->buying * $transaction->qty ?? 0), 0) }}
                    </td>
                </tr>
            @endforeach

            <tr class="notes">
                <td colspan="5">
                    <strong>NOTES:</strong><br>
                    Thank you for your prompt payment. Payment is due within 30 days.
                </td>
            </tr>

            <tr class="total">
                <td colspan="3"></td>
                <td>SUB TOTAL:</td>
                <td>{{ number_format($totalAmount) }}</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>- TOTAL DISC:</td>
                <td>{{ number_format($totalDiscount) }}</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>- TOTAL PAID:</td>
                <td>{{ number_format($totalPaid) }}</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>AMOUNT DUE:</td>
                <td>{{ number_format($totalDue) }}</td>
            </tr>
        </table>

        <p class="footer">
            Powered By Dukamax Business Software (0757 290 359)
        </p>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            window.print();

            var body = document.getElementById("body");
            body.addEventListener('click', function() {
                var personId = "{{ $person->id }}";
                var sellingId = "{{ $person->selling_id }}";

                @if ($entityType === 'customer')
                    var route =
                        "{{ route('customer.statement', ['customerId' => ':personId', 'sellingId' => ':sellingId']) }}";
                @elseif ($entityType === 'supplier')
                    var route =
                        "{{ route('supplier.statement', ['supplierId' => ':personId', 'sellingId' => ':sellingId']) }}";
                @else
                    var route = "#";
                @endif

                window.location.href = route
                    .replace(":personId", personId)
                    .replace(":sellingId", sellingId);
            });
        });
    </script>
</body>

</html>
