@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete"><i class="fa-solid fa-trash"></i> Delete
                    Selected</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer">
                    <i class="fa-solid fa-plus"></i> New Menus</button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">

                            <div class="modal-header">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <a href="{{ asset('dist\Menus.xls') }}" class="btn btn-primary"><i
                                                        class="fas fa-download"></i>Get Excel</a>
                                            </td>

                                            <td>
                                                <form action="{{ route('upload.menus.excel') }}" method="POST"
                                                    enctype="multipart/form-data" class="was-validated">
                                                    @csrf
                                                    @method('POST')

                                                    <!-- File Input -->
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="file"
                                                                name="file" required
                                                                onchange="changeFileName(this.files)">
                                                            <label class="custom-file-label" for="file">Choose
                                                                Excel</label>
                                                        </div>

                                                        <!-- Upload Button -->
                                                        <button type="submit" class="btn btn-success">
                                                            <i class="fa fa-upload mr-1"></i> Upload Excel
                                                        </button>
                                                    </div>
                                                </form>
                                            <td>
                                                <a href="#" class="btn btn-danger">Rejected stock</a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <form action="{{ route('menu.store') }}" method="POST" enctype="multipart/form-data"
                                class="was-validated">
                                @csrf
                                @method('POST')

                                <div class="card-body">
                                    <label for="menu" class="form-label fw-bold">Menu Name</label>
                                    <input type="text" name="menu" id="menu" required class="form-control"
                                        placeholder="Enter menu name">

                                    <label for="category" class="form-label fw-bold">Category</label>
                                    <select name="category" id="category" class="form-control">
                                        <option disabled selected value="">-- Choose Category --</option>
                                        @foreach ($categories->skip(1) as $category)
                                            <option value="{{ $category->id }}">--
                                                {{ $category->name }} --</option>
                                        @endforeach
                                    </select>

                                    <label for="selling" class="form-label fw-bold">Selling Price</label>
                                    <input type="text" name="selling" id="selling" required class="form-control"
                                        placeholder="Enter selling price">

                                    <label for="unit" class="form-label fw-bold">Unit</label>
                                    <select name="unit" id="unit" class="form-control" required>
                                        <option disabled selected value="">-- Select Unit --</option>
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id }}">-- {{ $unit->name }} --</option>
                                        @endforeach
                                    </select>

                                    <label for="location" class="form-label fw-bold">Location</label>
                                    <select name="location" id="location" class="form-control" required>
                                        <option disabled selected value="">-- Select Location --
                                        </option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>

                                    <label for="image" class="form-label fw-bold">Image</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" name="image" id="image" class="custom-file-input"
                                                onchange="document.getElementById('image-label').innerText = this.files[0].name">
                                            <label class="custom-file-label" id="image-label" for="image">Choose
                                                file</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-sm"> <i class="fa fa-paper-plane"></i>
                                        Register</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th style="width: 5%"><input type="checkbox" id="master"></th>
                        <th style="width:10%">S/N</th>
                        <th style="width:20%">Descrition</th>
                        <th>Price</th>
                        <th>Location</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse ($menus as $menu)
                        <tr>
                            <td><input type="checkbox" class="sub_chk" id="{{ $menu->id }}"></td>
                            <td> {{ $loop->index + 1 }}</td>
                            <td>{{ $menu->product }}</td>
                            <td>{{ number_format($menu->unit[0]->selling) }} @ {{ $menu->unit[0]->unit->name }} </td>
                            <td>{{ $menu->location->name }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    {{-- assign ingridients -> menu model --}}
                                    <a href="{{ route('assign.ingridients.view', $menu->id) }}"
                                        class="btn btn-info btn-sm"><i class="fa-solid fa-plus"></i> Add</a>

                                    {{-- edit trigger model --}}
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#edit-{{ $menu->id }}">
                                        <i class="fa-solid fa-pen-to-square fa-lg"></i> Edit
                                    </button>

                                    <div class="modal fade" id="edit-{{ $menu->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <form action="{{ route('menu.update', $menu->id) }}" method="POST"
                                                    class="was-validated">
                                                    @csrf
                                                    @method('PUT')

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Update
                                                            {{ $menu->product }}'s details
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <label for="menu" class="form-label fw-bold">Menu Name</label>
                                                        <input type="text" name="menu" id="menu" required
                                                            class="form-control" placeholder="Enter menu name"
                                                            value="{{ old('menu', $menu->product) }}">

                                                        <label for="category" class="form-label fw-bold">Category</label>
                                                        <select name="category" id="category" class="form-control">
                                                            <option disabled value="">-- Choose Category --</option>
                                                            @foreach ($categories as $category)
                                                                <option value="{{ $category->id }}"
                                                                    {{ $category->id == old('category', $menu->category_id ?? '') ? 'selected' : '' }}>
                                                                    -- {{ $category->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="selling" class="form-label fw-bold">Selling
                                                            Price</label>
                                                        <input type="text" name="selling" id="selling" required
                                                            class="form-control" placeholder="Enter selling price"
                                                            value="{{ old('selling', $menu->unit[0]->selling ?? '') }}">

                                                        <label for="unit" class="form-label fw-bold">Unit</label>
                                                        <select name="unit" id="unit" class="form-control"
                                                            required>
                                                            <option disabled value="">-- Select Unit --</option>
                                                            @foreach ($units as $unit)
                                                                <option value="{{ $unit->id }}"
                                                                    {{ $unit->id == old('unit', $menu->unit[0]->unit_id ?? '') ? 'selected' : '' }}>
                                                                    -- {{ $unit->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="location" class="form-label fw-bold">Location</label>
                                                        <select name="location" id="location" class="form-control"
                                                            required>
                                                            <option disabled value="">-- Select Location --</option>
                                                            @foreach ($sellings as $selling)
                                                                <option value="{{ $selling->location_id }}"
                                                                    {{ $selling->location_id == old('location', $menu->location_id ?? '') ? 'selected' : '' }}>
                                                                    -- {{ $selling->location->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="image" class="form-label fw-bold">Image</label>
                                                        <div class="input-group">
                                                            <div class="custom-file">
                                                                <input type="file" name="image" id="image"
                                                                    class="custom-file-input"
                                                                    onchange="document.getElementById('image-label').innerText = this.files[0].name">
                                                                <label class="custom-file-label" id="image-label"
                                                                    for="image">Choose
                                                                    file</label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button class="btn btn-primary btn-sm"><i
                                                                class="fa fa-paper-plane"></i>
                                                            Update</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Delete Button & Form --}}
                                    <button type="button" class="btn btn-danger btn-sm delete"
                                        data-id="{{ $menu->id }}">
                                        <i class="fa fa-trash-alt" aria-hidden="true"></i> Delete
                                    </button>

                                    <form action="{{ route('menu.delete', $menu->id) }}" method="POST"
                                        id="deleteform{{ $menu->id }}">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <div class="d-flex flex-column align-items-center">
                                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                        style="width: 80px; opacity: 0.5;">
                                    <h5 class="mt-3 text-secondary font-weight-bold">No Menus Found</h5>
                                    <p class="text-muted mb-0">You haven't added any menu yet.<br>
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target=".customer">
                                            <i class="fa-solid fa-plus"></i> New Menus</button>
                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @section('scripts')
        <script>
            $('#menus').DataTable();

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $('#master').on('click', function() {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }
            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('menus.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully.',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });
                }
            });

            $('.delete').on('click', function() {
                let menuId = $(this).data('id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: "This action cannot be undone!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#deleteform' + menuId).submit();
                    }
                });
            });
        </script>
    @endsection

@endsection
