@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <form action="{{ route('fast.and.slow.moving.products') }}" onsubmit="showSpinner()" method="get"
                class="was-validated">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="location" id="location" class="form-control" style="text-align: center" required>
                                    <option disabled selected value="">-- Choose Location --
                                    </option>
                                    @foreach ($sellings as $selling)
                                        <option value="{{ $selling->id }}">
                                            -- {{ $selling->location->name }} --</option>
                                    @endforeach
                                </select>
                            </td>

                            <td>
                                <select name="duration" id="duration" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Choose Duration --</option>
                                    <option value="today">-- Today --</option>
                                    <option value="set date">-- Set Date --</option>
                                    <option value="set duration">-- Set Duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i>
                                    Search</button>
                            </td>
                        </tr>
                    </tbody>

                </table>
            </form>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped">
                    <thead class="thead-dark">
                        <tr class="text-center">
                            <th style="width: 5%;"><i class="fas fa-hashtag"></i></th>
                            <th style="width: 40%;"><i class="fas fa-box-open"></i> Product Name</th>
                            <th style="width: 15%;"><i class="fas fa-sort-amount-up-alt"></i> Quantity</th>
                            <th style="width: 20%;"><i class="fas fa-tag"></i> Price</th>
                            <th style="width: 20%;"><i class="fas fa-coins"></i> Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($products as $index => $item)
                            <tr>
                                <td class="text-center">{{ $index + 1 }}</td>
                                <td class="text-capitalize text-center">{{ $item->name }}</td>
                                <td class="text-center">{{ number_format($item->total_qty) }} {{ $item->unit }}</td>
                                <td class="text-center"> {{ number_format($item->price, 2) }}</td>
                                <td class="text-center font-weight-bold"> {{ number_format($item->total_amount, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">No products found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    @section('scripts')
        <script>
            $("#moving-items").DataTable({
                "pageLength": 200,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            // Initiate variables.
            let start;
            let end;
            let type;

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#duration").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });
        </script>
    @endsection

@endsection
