<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12.5px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:nth-child(2),
        .items tbody tr td:nth-child(2) {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 12px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 13px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        .line {
            border-top: 1px solid black !important;
        }

        .heading .sn {
            width: 5%;
        }

        .heading.rate {
            width: 20%;
        }

        .heading.amount {
            width: 25%;
        }

        .heading.qty {
            width: 5%
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body>
    <header>
        <div id="logo" class="media" data-src="logo.png" src="./logo.png"></div>
    </header>
    <table class="bill-details">
        <tbody>
            <tr style="text-align: center">
                <td><span>Business name</span><br>
                    <span>Ubungo, Singida</span><br>
                    <span>0717000000</span><br>
                    <span>08-08-2023</span><br>
                    <span class="receipt">Sale Reciept</span>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="items">
        <thead>
            <tr>
                <th class="heading qty">SN</th>
                <th class="heading name">Item</th>
                <th class="heading rate">UOM</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate" style="text-align: right;">Price</th>
                <th class="heading amount">Amount</th>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td style="text-align: center;">1</td>
                <td>Chocolate milkshake</td>
                <td style="text-align: center;">1</td>
                <td style="text-align: center;">78</td>
                <td style="text-align: right;">200</td>
                <td style="text-align: right;">200</td>
            </tr>
            <tr>
                <td style="text-align: center;">2</td>
                <td>Chocolate milkshake</td>
                <td style="text-align: center;">1</td>
                <td style="text-align: center;">78</td>
                <td style="text-align: right;">200</td>
                <td style="text-align: right;">200</td>
            </tr>
            <tr>
                <td style="text-align: center;">3</td>
                <td>Chocolate milkshake</td>
                <td style="text-align: center;">1</td>
                <td style="text-align: center;">78</td>
                <td style="text-align: right;">200</td>
                <td style="text-align: right;">200</td>
            </tr>
            <tr>
                <td style="text-align: center;">4</td>
                <td>Chocolate milkshake</td>
                <td style="text-align: center;">1</td>
                <td style="text-align: center;">78</td>
                <td style="text-align: right;">200</td>
                <td style="text-align: right;">200</td>
            </tr>

            <tr>
                <th colspan="5" class="total text" style="text-align: right;">Total</th>
                <th class="total price" style="text-align: right;white-space: nowrap;">Tsh 12132</th>
            </tr>
        </tbody>
    </table>
    <section>
        <p>
            Paid by : <span>CASH</span>
        </p>
        <p style="text-align:center">
            Thank you for your visit!
        </p>
    </section>
    <footer style="text-align:center">
        <p>Powered by Dukamax Business Software</p>
    </footer>

    <script>
        window.print();
    </script>
</body>

</html>
