@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        {{-- <center>
            <h5 class="text-black-50">Events</h5>
        </center> --}}
    </div>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">
        <button type="button" id="deleteall" class="btn btn-danger">Delete selected</button>

        <div class="row">
            <div class="col-7">
                <table class="table table-stripped">
                    <thead>
                        <tr>
                            <th style="width: 5%"><input type="checkbox" id="checkall"></th>
                            <th style="width: 15%">S/N</th>
                            <th>Events</th>
                            <th>Price</th>
                            <th style="width:20%">Action</th>
                        </tr>
                    </thead>
                    @foreach ($events as $event)
                        <tr>
                            <td><input type="checkbox" class="selected" id="{{ $event->id }}"></td>
                            <td>{{ $loop->index + 1 }}</td>
                            <td>{{ $event->name }}</td>
                            <td>{{ $event->price }}</td>
                            <td>

                                {{-- delete model --}}

                                <button class="btn btn-danger delete" id="{{ $event->id }}">
                                    <i class="fa fa-trash fa-lg" aria-hidden="true"></i>

                                    <form action="{{ route('event.destroy', $event->id) }}" method="GET"
                                        id="deleteform{{ $event->id }}">
                                    </form>
                                </button>

                                <button type="button" class="btn btn-info" data-toggle="modal"
                                    data-target="#edit-{{ $event->id }}">
                                    <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                </button>

                                <div class="modal fade" id="edit-{{ $event->id }}" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title">Edit event</h5>
                                                <button type="button" class="btn btn-danger" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('event.update', $event->id) }}" method="post">
                                                @csrf
                                                <div class="modal-body">

                                                    <label for="1">Event name</label>
                                                    <input type="text" name="name" id="1"
                                                        value="{{ $event->name }}" class="form-control" required>

                                                    <label for="2">Event price</label>
                                                    <input type="text" name="price" id="2"
                                                        value="{{ $event->price }}" class="form-control" required>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-info btn-block">Confirm</button>
                                                </div>

                                            </form>

                                        </div>
                                    </div>
                                </div>

                            </td>

                        </tr>
                    @endforeach
                </table>

            </div>

            <div class="col-sm">

                <form action="{{ Route('event.store') }}" method="post">
                    @csrf

                    <table class="table table-striped" id="table">

                        <thead style="text-align: center;">

                            <tr>
                                <th scope="col" style="width:2%">#</th>
                                <th scope="col">Event</th>
                                <th scope="col">Price</th>
                                <th scope="col"><button type="button" class="btn btn-info" id="addRow">+</button>
                                </th>
                            </tr>

                        </thead>

                        <tbody id="tbody">

                        </tbody>

                    </table>

                    <br>
                    <button class="btn btn-info btn-block"> Add event</button>

                </form>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script type="text/javascript">
        $(document).ready(function() {

            var index = 1;

            // add row
            $("#addRow").on("click", function(e) {

                e.preventDefault();

                var tr =

                    '<tr id= "tr' + index + '">' +

                    '<td>' + index + '</td>' +

                    '<td><input type="text" name="name[]" class="form-control" placeholder="Enter event name" style = "text-align: center;" required></td>' +

                    '<td><input type="number" name="price[]" class="form-control" placeholder="Enter event price" style = "text-align: center;" required></td>' +

                    '<td><button type="button"id="' + index +
                    '" class="btn btn-danger removeRow">-</button></td>' +

                    '</tr>';

                $("#tbody").append(tr);
                index++;

                $(".removeRow").on("click", function() {

                    var id = $(this).attr("id");

                    $("#tr" + id).remove();
                });

            });

            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#deleteall").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('events.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });

        });
    </script>
@endsection

@endsection
