@extends('layouts.master')

@section('content')

    @include('patial.loading-spinner')

    {{-- Content Header (Page header) --}}
    <div class="content-header">
        <center>
            {{-- <h5 class="text-black-50">Role Permissions</h5> --}}

            {{-- Loading indicator --}}
            <div id="loading-indicator" class="spinner">
                <div class="rect1"></div>
                <div class="rect2"></div>
                <div class="rect3"></div>
                <div class="rect4"></div>
                <div class="rect5"></div>
            </div>
        </center>
    </div>

    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">
        <div class="card">
            <h5 class="card-header">Edit {{ $roles->name }} Permissions</h5>

            <div class="card-body">
                <form action="{{ route('update.role') }}"  onsubmit="showSpinner()" method="POST">
                    @csrf
                    <input type="hidden" name="role" value="{{ $id }}">

                    <div class="container">
                        <div class="row">
                            <div class="col" style="display: grid;grid-template-columns: auto auto;">
                                <div class="form-check form-group mb-2">
                                    <input class="form-check-input" type="checkbox" id="checkall">
                                    <label class="form-check-label" for="checkall">
                                        Check all permissions
                                    </label>
                                </div>

                                @foreach ($permissions as $permission)
                                    <div class="form-check form-group mb-2">
                                        @php
                                            $isGranted = App\Models\RoleHasPermission::where([['permission_id', $permission->id], ['role_id', $id]])->first();
                                        @endphp
                                        <input class="form-check-input selected" type="checkbox"
                                            value="{{ $permission->id }}" name="permissions[]" id="{{ $permission->id }}"
                                            @if ($isGranted != null) checked @endif>
                                        <label style="text-transform: capitalize" class="form-check-label"
                                            for="{{ $permission->id }}">
                                            {{ $permission->name }}
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <button type="submit" id="update"
                        class="form-control btn btn-primary col-md-2 offset-md-4 mb-3"><i class="fa fa-paper-plane"></i> Update</button>
                </form>
            </div>
        </div>
    </div>
    {{-- /.content --}}

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {
            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });
        });

        function showSpinner() {
             // Show spinner to be called on form submission
            document.querySelector('.spinner').style.display = 'block';
          }

          window.addEventListener('load', function() {
            // hide the spinner after the page is loaded
            document.querySelector('.spinner').style.display = 'none';
          });

    </script>
@endsection

@endsection
