@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-danger btn-sm" id="bulkdelete"><i class="fa-solid fa-trash"></i> Delete
                    Selected</button>

                <!-- Large modal -->
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target=".customer">
                    <i class="fa-solid fa-plus"></i> New Drink</button>

                <div class="modal fade customer" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">

                            <div class="modal-header">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <a href="{{ asset('dist\Menus.xls') }}" class="btn btn-primary"><i
                                                        class="fas fa-download"></i>Get Excel</a>
                                            </td>

                                            <td>
                                                <form action="{{ route('upload.menus.excel') }}" method="POST"
                                                    enctype="multipart/form-data" class="was-validated">
                                                    @csrf
                                                    @method('POST')

                                                    <!-- File Input -->
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="file"
                                                                name="file" required
                                                                onchange="changeFileName(this.files)">
                                                            <label class="custom-file-label" for="file">Choose
                                                                Excel</label>
                                                        </div>


                                                        <!-- Upload Button -->
                                                        <button type="submit" class="btn btn-success">
                                                            <i class="fa fa-upload mr-1"></i> Upload Excel
                                                        </button>
                                                    </div>
                                                </form>

                                            <td>
                                                <a href="#" class="btn btn-danger">Rejected stock</a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <form action="{{ route('drink.store') }}" method="POST" enctype="multipart/form-data"
                                class="was-validated">
                                @csrf
                                @method('POST')

                                <div class="card-body">
                                    <label for="name" class="form-label fw-bold">Name</label>
                                    <input type="text" name="name" id="name" required class="form-control"
                                        placeholder="Enter drink name">

                                    <label for="category" class="form-label fw-bold">Category</label>
                                    <select name="category" id="category" class="form-control">
                                        <option value="">-- Choose Category
                                            --</option>
                                        @foreach ($categories->skip(1) as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category', $ingredient->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                                -- {{ $category->name }} --
                                            </option>
                                        @endforeach
                                    </select>

                                    <label for="buying" class="form-label fw-bold">Buying Price</label>
                                    <input type="text" name="buying" id="buying" required class="form-control"
                                        placeholder="Enter buying price">

                                    <label for="selling" class="form-label fw-bold">Selling Price</label>
                                    <input type="text" name="selling" id="selling" required class="form-control"
                                        placeholder="Enter selling price">

                                    <label for="unit" class="form-label fw-bold">Unit</label>
                                    <select name="unit" id="unit" class="form-control" required>
                                        <option disabled selected value="">-- Select Unit --</option>
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id }}">-- {{ $unit->name }} --</option>
                                        @endforeach
                                    </select>

                                    <label for="qty" class="form-label fw-bold"> QTY</label>
                                    <input type="text" name="qty" id="qty" required class="form-control"
                                        placeholder="Enter qty">

                                    <label for="min-qty" class="form-label fw-bold">Min QTY</label>
                                    <input type="text" name="min-qty" id="min-qty" required class="form-control"
                                        placeholder="Enter min qty">

                                    <label for="location" class="form-label fw-bold">Location</label>
                                    <select name="location" id="location" class="form-control" required>
                                        <option disabled selected value="">-- Select Location --
                                        </option>
                                        @foreach ($sellings as $selling)
                                            <option value="{{ $selling->location_id }}">
                                                -- {{ $selling->location->name }} --
                                            </option>
                                        @endforeach
                                    </select>

                                </div>

                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-sm"> <i class="fa fa-paper-plane"></i>
                                        Register</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover" id="menus">
                <thead class="table-dark">
                    <tr>
                        <th style="width: 5%"><input type="checkbox" id="master"></th>
                        <th style="width:10%">S/N</th>
                        <th style="width:20%">Item</th>
                        <th>Buying</th>
                        <th>Selling</th>
                        <th>Location</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse ($menus as $menu)
                        <tr>
                            <td><input type="checkbox" class="sub_chk" id="{{ $menu->id }}"></td>
                            <td> {{ $loop->index + 1 }}</td>
                            <td>{{ $menu->product }}</td>
                            <td>{{ number_format($menu->buying) }} @ {{ $menu->unit[0]->unit->name }}</td>
                            <td>{{ number_format($menu->unit[0]->selling) }} @ {{ $menu->unit[0]->unit->name }} </td>
                            <td>{{ $menu->location->name }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    {{-- edit trigger model --}}
                                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                        data-target="#edit-{{ $menu->id }}">
                                        <i class="fa-solid fa-pen-to-square fa-lg"></i> Edit
                                    </button>

                                    <div class="modal fade" id="edit-{{ $menu->id }}" tabindex="-1" role="dialog"
                                        aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Edit Product Details
                                                    </h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('drink.update', $menu->id) }}" method="POST"
                                                    enctype="multipart/form-data" class="was-validated">
                                                    @csrf
                                                    @method('PUT')

                                                    <div class="card-body">
                                                        <label for="name" class="form-label fw-bold">Name</label>
                                                        <input type="text" name="name" id="name" required
                                                            class="form-control"
                                                            value="{{ old('name', $menu->product) }}"
                                                            placeholder="Enter drink name">

                                                        <label for="category" class="form-label fw-bold">Category</label>
                                                        <select name="category" id="category" class="form-control">
                                                            <option value="">-- Choose Category
                                                                --</option>
                                                            @foreach ($categories as $category)
                                                                <option value="{{ $category->id }}"
                                                                    {{ old('category', $ingredient->category_id ?? '') == $category->id ? 'selected' : '' }}>
                                                                    -- {{ $category->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="buying" class="form-label fw-bold">Buying
                                                            Price</label>
                                                        <input type="text" name="buying" id="buying" required
                                                            class="form-control"
                                                            value="{{ old('buying', $menu->buying) }}"
                                                            placeholder="Enter buying price">

                                                        <label for="selling" class="form-label fw-bold">Selling
                                                            Price</label>
                                                        <input type="text" name="selling" id="selling" required
                                                            class="form-control"
                                                            value="{{ old('selling', $menu->unit[0]->selling ?? '') }}"
                                                            placeholder="Enter selling price">

                                                        <label for="unit" class="form-label fw-bold">Unit</label>
                                                        <select name="unit" id="unit" class="form-control"
                                                            required>
                                                            <option disabled value="">-- Select Unit --</option>
                                                            @foreach ($units as $unit)
                                                                <option value="{{ $unit->id }}"
                                                                    {{ old('unit', $menu->stock[0]->unit_id ?? '') == $unit->id ? 'selected' : '' }}>
                                                                    -- {{ $unit->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="qty" class="form-label fw-bold">QTY</label>
                                                        <input type="text" name="qty" id="qty" required
                                                            class="form-control"
                                                            value="{{ old('qty', $menu->stock[0]->qty ?? '') }}"
                                                            placeholder="Enter qty">

                                                        <label for="min-qty" class="form-label fw-bold">Min QTY</label>
                                                        <input type="text" name="min-qty" id="min-qty" required
                                                            class="form-control"
                                                            value="{{ old('min-qty', $menu->stock[0]->min_qty ?? '') }}"
                                                            placeholder="Enter min qty">

                                                        <label for="location" class="form-label fw-bold">Location</label>
                                                        <select name="location" id="location" class="form-control"
                                                            required>
                                                            <option disabled value="">-- Select Location --</option>
                                                            @foreach ($sellings as $selling)
                                                                <option value="{{ $selling->location_id }}"
                                                                    {{ old('location', $menu->location_id) == $selling->location_id ? 'selected' : '' }}>
                                                                    -- {{ $selling->location->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                    </div>

                                                    <div class="card-footer text-center">
                                                        <button class="btn btn-primary btn-sm">
                                                            <i class="fa fa-edit"></i> Update
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- delete model --}}
                                    <button class="btn btn-danger btn-sm delete" id="{{ $menu->id }}">
                                        <i class="fa fa-trash-alt" aria-hidden="true"></i> Delete

                                        <form action="{{ route('drink.delete', $menu->id) }}" method="GET"
                                            id="deleteform{{ $menu->id }}">
                                        </form>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <div class="d-flex flex-column align-items-center">
                                    <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                        style="width: 80px; opacity: 0.5;">
                                    <h5 class="mt-3 text-secondary font-weight-bold">No Menus Found</h5>
                                    <p class="text-muted mb-0">You haven't added any menu yet.<br>
                                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                            data-target=".customer">
                                            <i class="fa-solid fa-plus"></i> New Drinks</button>

                                    </p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @section('scripts')
        <script>
            $("#menus").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            $("#success").fadeIn("slow");
            setTimeout(function() {
                $("#success").fadeOut("slow")
            }, 3000);

            $('#master').on('click', function() {

                if ($(this).is(':checked', true)) {
                    $(".sub_chk").prop('checked', true);
                } else {
                    $(".sub_chk").prop('checked', false);
                }

            });

            $("#bulkdelete").on("click", function() {
                var selected = [];

                $(".sub_chk:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('menus.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Deleted successfully.',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });
                }
            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });
        </script>
    @endsection

@endsection
