<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f6f6f6;
        }

        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            background-color: #fff;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 10px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(4),
        .invoice-box table tr td:nth-child(5) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.top table td.title-right {
            text-align: right;
            font-size: 16px;
            vertical-align: bottom;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        .invoice-box .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #777;
        }

        .invoice-box .footer a {
            color: #337ab7;
            text-decoration: none;
        }

        .invoice-box .amount-due {
            background-color: #e0ebff;
            font-size: 24px;
            padding: 10px;
            text-align: center;
            color: #333;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <table class="table table-striped table-hover">
            <tr class="top">
                <td colspan="5">
                    <table>
                        Invoice<hr>
                        <tr>
                            <td class="title-left">
                                <p><strong>BILL FROM:</strong><br>Company Name<br>Address<br>City<br>Country<br>Postal</p>
                            </td>
                            <td class="title-right">
                                <p><strong>BILL TO:</strong><br>Company Name<br>Address<br>City<br>Country<br>Postal</p>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="information">
                <td colspan="5">
                    <table>
                        <tr>
                            <td>
                                <strong>INVOICE NO #</strong><br>123456
                            </td>
                            <td>
                                <strong>DATE</strong><br>12/31/20
                            </td>
                            <td>
                                <strong>INVOICE DUE DATE</strong><br>12/31/20
                            </td>
                            <td class="amount-due">
                                <strong>AMOUNT DUE</strong><br>$0000.00
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="heading">
                <td>ITEMS</td>
                <td>DESCRIPTION</td>
                <td>QUANTITY</td>
                <td>PRICE</td>
                <td>AMOUNT</td>
            </tr>

            <tr class="item">
                <td>Item 1</td>
                <td>Description</td>
                <td>3</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 2</td>
                <td>Description</td>
                <td>2</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 3</td>
                <td>Description</td>
                <td>3</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 4</td>
                <td>Description</td>
                <td>1</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 5</td>
                <td>Description</td>
                <td>1</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 6</td>
                <td>Description</td>
                <td>1</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 7</td>
                <td>Description</td>
                <td>1</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="item">
                <td>Item 8</td>
                <td>Description</td>
                <td>1</td>
                <td>$00.00</td>
                <td>$0000.00</td>
            </tr>

            <tr class="notes">
                <td colspan="5">
                    <strong>NOTES:</strong><br>
                    Thank you for your prompt payment. Payment is due within 30 days.
                </td>
            </tr>

            <tr class="total">
                <td colspan="3"></td>
                <td>SUB-TOTAL:</td>
                <td>$0000.00</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>TAX RATE:</td>
                <td>0%</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>TAX:</td>
                <td>$000.00</td>
            </tr>
            <tr class="total">
                <td colspan="3"></td>
                <td>TOTAL:</td>
                <td>$0000.00</td>
            </tr>
        </table>

        <p class="footer">
           Powered By Dukamax Business Software (0757 290 359)
        </p>
    </div>
</body>

</html>
