@extends('layouts.master')

@section('content')

    <div class="card table-responsive">
        <div class="card-header">
            Orders poised for dispatch...
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped align-middle shadow-sm" id="dispatch">
                    <thead class="table-dark">
                        <tr>
                            <th style="width:1%">#</th>
                            <th>Customer</th>
                            <th>Expectaion</th>
                            <th style="width: 20%">Stage</th>
                            <th>Progess</th>
                            <th style="width:25%">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($orders as $order)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $order->customer ? ($order->customer->trashed() ? '[Deleted] ' : '') . $order->customer->name : 'LMT Textile' }}
                                </td>
                                <td>{{ $order->expectation }}</td>
                                <td>
                                    @if ($order->stage == 1)
                                        <span class="badge bg-danger rounded-pill"
                                            id="{{ $order->id }}">Knitting...</span>
                                    @elseif ($order->stage == 2)
                                        <span class="badge bg-warning text-dark rounded-pill"
                                            id="{{ $order->id }}">Cutting...</span>
                                    @elseif ($order->stage == 3)
                                        <span class="badge bg-secondary rounded-pill"
                                            id="{{ $order->id }}">Joining...</span>
                                    @elseif ($order->stage == 4)
                                        <span class="badge bg-primary rounded-pill"
                                            id="{{ $order->id }}">Ironing...</span>
                                    @elseif ($order->stage == 5)
                                        <span class="badge bg-info text-dark rounded-pill"
                                            id="{{ $order->id }}">Embroidering...</span>
                                    @elseif ($order->stage == 6)
                                        <span class="badge bg-success rounded-pill"
                                            id="{{ $order->id }}">Packaging...</span>
                                    @elseif ($order->stage == 7)
                                        <span class="badge bg-success rounded-pill"
                                            id="{{ $order->id }}">Dispatch...</span>
                                    @endif
                                </td>

                                <td>
                                    <!-- Progress bar for the current order -->
                                    <div class="progress" style="margin-top: 5px">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0"
                                            aria-valuemax="100" style="width: 0%">
                                            0%
                                        </div>
                                    </div>
                                </td>

                                <td>
                                    <div class="btn-group" role="group">
                                        {{-- Submit payment modal --}}
                                        <button type="button" class="btn btn-sm btn-secondary deposite" data-toggle="modal"
                                            data-target="#deposite{{ $order->id }}"><i class="fa fa-coins"></i> Deposite
                                        </button>

                                        <div class="modal fade" id="deposite{{ $order->id }}" tabindex="-1">
                                            <div class="modal-dialog">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Post
                                                            {{ $order->customer ? $order->customer->name : 'LMT Textile' }}'s
                                                            Payment
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <form action="{{ route('production.order.payment', $order->id) }}"
                                                        id="payment-form{{ $order->id }}" method="get"
                                                        class="was-validated">
                                                        @csrf

                                                        <div class="modal-body">
                                                            <label for="date">Date</label>
                                                            <input type="text" name="date" id="date"
                                                                class="form-control" value="{{ Date('Y-m-d') }}">

                                                            <label for="customer">Customer</label>
                                                            <input type="text" name="customer" id="customer"
                                                                class="form-control"
                                                                value="{{ $order->customer ? $order->customer->name : 'LMT Textile' }}"
                                                                readonly>

                                                            <label for="amount">Amount</label>
                                                            <input type="text" name="amount" id="amount"
                                                                class="form-control" value="{{ number_format($order->due) }}" readonly>

                                                            <label for="paid">Paid amount</label>
                                                            <input type="text" name="paid" id="paid"
                                                                class="form-control" value="" required>

                                                            <label for="account">account</label>
                                                            <select name="account" id="account" class="form-control"
                                                                required>
                                                                <option disabled selected value="">-- Choose Account
                                                                    --
                                                                </option>
                                                                @foreach ($accounts as $account)
                                                                    <option value="{{ $account->id }}">--
                                                                        {{ $account->type }}
                                                                        -
                                                                        {{ $account->name }}--
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button"
                                                                class="btn btn-sm btn-primary payment"
                                                                id="{{ $order->id }}"><i
                                                                    class="fa fa-paper-plane fa-lg"></i>
                                                                Sumbmit Payment</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Dispatch Modal --}}
                                        <button type="button" class="btn btn-sm btn-success dispatch" data-toggle="modal"
                                            data-target="#exampleModal{{ $order->id }}">
                                            <i class="fa fa-truck-fast" aria-hidden="true"></i> Dispatch
                                        </button>

                                        <div class="modal fade" id="exampleModal{{ $order->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl" role="document">
                                                <div class="modal-content">

                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">
                                                            Dispatch
                                                            {{ $order->customer ? ($order->customer->trashed() ? '[Deleted] ' : '') . $order->customer->name : 'LMT Textile' }}
                                                            Order</h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                    <div class="modal-body">
                                                        <div class="table-responsive">
                                                            <table class="table table-striped table-bordered table-hover">

                                                                <thead class="thead-dark">
                                                                    <tr>
                                                                        <th scope="col">#</th>
                                                                        <th scope="col">Product Name</th>
                                                                        <th scope="col">Unit</th>
                                                                        <th scope="col">Size</th>
                                                                        <th scope="col">Color</th>
                                                                        <th scope="col">Main Design</th>
                                                                        <th scope="col">Sub Design</th>
                                                                        <th scope="col">QTY</th>
                                                                        <th scope="col">Price</th>
                                                                        <th scope="col">Amount</th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody>
                                                                    @foreach ($order->items as $item)
                                                                        <tr>
                                                                            <th scope="row">{{ $loop->index + 1 }}</th>
                                                                            <td>{{ $item->product ? $item->product->product : ($item->product()->withTrashed()->first() ? $item->product()->withTrashed()->first()->product : 'N/A') }}
                                                                            </td>
                                                                            <td>{{ $item->unit->name }}</td>
                                                                            <td>{{ $item->size }}</td>
                                                                            <td>{{ $item->color }}</td>
                                                                            <td>{{ $item->main }}</td>
                                                                            <td>{{ $item->sub }}</td>
                                                                            <td>{{ number_format($item->qty) }}</td>
                                                                            <td>{{ number_format($item->price) }}</td>
                                                                            <td>{{ number_format($item->price) }}</td>
                                                                        </tr>
                                                                    @endforeach

                                                                    <tr>
                                                                        <th scope="row">&nbsp</th>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td class="font-weight-bold text-success">
                                                                            <h5>Total</h5>
                                                                        </td>
                                                                        <td class="font-weight-bold text-success">
                                                                            <h5>{{ number_format($order->total) }}</h5>
                                                                        </td>
                                                                    </tr>

                                                                    <tr>
                                                                        <th scope="row">&nbsp</th>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td class="font-weight-bold text-info">
                                                                            <h5>Paid -</h5>
                                                                        </td>
                                                                        <td class="font-weight-bold text-info">
                                                                            <h5>{{ number_format($order->paid) }}</h5>
                                                                        </td>
                                                                    </tr>

                                                                    <tr>
                                                                        <th scope="row">&nbsp</th>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td>&nbsp</td>
                                                                        <td class="font-weight-bold text-danger">
                                                                            <h3>Due</h3>
                                                                        </td>
                                                                        <td class="font-weight-bold text-danger">
                                                                            <h3>({{ number_format($order->due) }})</h3>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-sm btn-info dispatch"
                                                            data-toggle="modal"
                                                            data-target="#transaport{{ $order->id }}">
                                                            <i class="fa-solid fa-truck fa-lg"></i> Transport cost
                                                        </button>

                                                        <div class="modal fade" id="transaport{{ $order->id }}"
                                                            tabindex="-1" role="dialog"
                                                            aria-labelledby="exampleModalLabel" aria-hidden="true"
                                                            data-backdrop="static" data-keyboard="false">
                                                            <div class="modal-dialog modal-md modal-dialog-centered"
                                                                role="document">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="exampleModalLabel">
                                                                            Enter tranport cost</h5>

                                                                        <button type="button" class="close"
                                                                            data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>

                                                                    <form
                                                                        action="{{ route('process.dispatch', ['order_id' => $order->id]) }}"
                                                                        method="post"
                                                                        id="dispatch-form{{ $order->id }}"
                                                                        class="was-validated">

                                                                        @csrf

                                                                        <div class="modal-body">
                                                                            <table class="table table-sm">
                                                                                <tr>
                                                                                    <td>
                                                                                        Select Transport
                                                                                    </td>
                                                                                    <td>
                                                                                        <select name="transport"
                                                                                            id="transaport{{ $order->id }}"
                                                                                            class="form-control">
                                                                                            <option selected disabled
                                                                                                value="">-- Select
                                                                                                Transport Type --</option>
                                                                                            <option value="1">--
                                                                                                Pikipiki
                                                                                                --
                                                                                            </option>
                                                                                            <option value="2">-- Gari
                                                                                                --
                                                                                            </option>
                                                                                        </select>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        Transport Cost
                                                                                    </td>
                                                                                    <td>
                                                                                        <input type="text"
                                                                                            name="cost"
                                                                                            id="cost{{ $order->id }}"
                                                                                            class="form-control"
                                                                                            placeholder="Enter transaport cost">
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>
                                                                                        How many trips
                                                                                    </td>
                                                                                    <td>
                                                                                        <input type="number"
                                                                                            name="trip"
                                                                                            id="trip{{ $order->id }}"
                                                                                            class="form-control"
                                                                                            placeholder="Enter number of trips">
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>

                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                id="{{ $order->id }}"
                                                                                class="btn btn-sm btn-danger confirm-dispatch"><i
                                                                                    class="fa-solid fa-truck fa-lg"></i>
                                                                                Dispatch</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Cancel Modal --}}
                                        <button class="btn btn-sm btn-danger cancel" id="{{ $order->id }}">
                                            <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i> Delete
                                            <form action="{{ route('cancel.production.order', $order->id) }}"
                                                method="GET" id="cancel-form{{ $order->id }}">
                                            </form>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        // Initiate table data
        $("#dispatch").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        // Create a new Intl.NumberFormat object
        var formatter = new Intl.NumberFormat();

        $(".deposite").on("click", function() {
            let amount = $("#amount").val();
            $("#amount").val(formatter.format(amount)); // Remove commas and parse as base 10
        });

        $("#paid").on("input", function() {
            let user_input = $(this).val();
            user_input = formatter.format(user_input.replace(/,/g, ''));
            $("#paid").val(user_input); // Remove commas and parse as base 10

            let due_amount = $("#amount").val();
            due_amount = formatter.format(due_amount.replace(/,/g, ''));

            if (due_amount === user_input) {
                $("#paid").attr("readonly", true);
            } else {
                $("#paid").attr("readonly", false);
            }
        });

        $("#transaport").on("change", function() { // listen for change on transaport feild.
            let transport = $(this).val();
            if (transport == 1) {
                $("#cost").val("");
                $("#cost").val(5000);
            } else if (transport == 2) {
                $("#cost").val("");
            }
        });

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        document.addEventListener("DOMContentLoaded", function() {
            var progressBars = document.querySelectorAll('.progress-bar');
            progressBars.forEach(function(progressBar) {
                var maxProgress = parseInt(progressBar.getAttribute('aria-valuemax'));
                var width = 0;
                var interval = setInterval(function() {
                    if (width >= maxProgress) {
                        clearInterval(interval);
                    } else {
                        width++;
                        progressBar.style.width = width + '%';
                        progressBar.setAttribute('aria-valuenow', width);
                        progressBar.textContent = width +
                            '%'; // Update the text content with current progress
                    }
                }, 10);
            });
        });

        $(".payment").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "Post payment for this order?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, forward!'
            }).then((result) => {
                if (result.isConfirmed) {
                    showSpinner();
                    document.getElementById('payment-form' + id).submit();
                }
            })
        });

        // Handle Dispatch button click
        $(".confirm-dispatch").on("click", function() {
            var id = $(this).attr("id");

            let trans = $("#transaport" + id).val();
            let cost = $("#cost" + id).val();
            let trip = $("#trip" + id).val();

            if (trans = "" || cost == "" || trip == "") {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'All fields are required!'
                })
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "you are abount to distpatch this order?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, forward!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        showSpinner()
                        document.getElementById("dispatch-form" + id).submit();
                    }
                })
            }
        });

        // Handle cancel button click
        $(".cancel").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, forward!'
            }).then((result) => {
                if (result.isConfirmed) {
                    showSpinner()
                    document.getElementById("cancel-form" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
