@extends('layouts.master')

@section('content')

    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>
    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h5>Dirty rooms..</h5>
            </div>

            <div class="card-body">

                <table class="table table-stripped" style="text-align: center" id="customer">
                    <thead>
                        <tr>
                            <th>S/N</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($rooms as $room)
                            <tr>
                                <td> {{ $loop->index + 1 }}</td>
                                <td>{{ $room->name }}</td>
                                <td>

                                    {{-- Block room --}}
                                    <button type="button" class="btn btn-secondary" data-toggle="modal"
                                        data-target="#block-{{ $room->id }}" id="block">
                                        @if ($room->block == 'blocked')
                                            Ready
                                        @else
                                            Dirty
                                        @endif
                                    </button>

                                    <div class="modal fade" id="block-{{ $room->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <form action="{{ route('room.block', $room->id) }}" method="post">
                                                    @csrf

                                                    <div class="modal-body">
                                                        <label for="reason">Block reason</label>
                                                        <select name="reason" id="reason" class="form-control"
                                                            style="text-align: center">
                                                            <option value="">--Select reason--</option>
                                                            <option value="construction">Contruction</option>
                                                            <option value="cleaning">Cleaning</option>
                                                        </select>
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary"
                                                            id="confirmblock">Submit</button>

                                                    </div>

                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>
                        <tr>
                            <th>S/N</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $("#customer").DataTable({
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);
    </script>
@endsection

@endsection
