@extends('layouts.master')

@section('content')

    <div class="card">

        <div class="card-header">

            <button type="button" class="btn btn-outline-danger" id="deleteall">
                <i class="fa-solid fa-trash-alt"></i> Delete selected</button>

            <!-- Large modal -->
            <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target=".debtor">
                <i class="fa-solid fa-plus"></i>
                New Debtor</button>

            <div class="modal fade debtor" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">

                        <div class="card">

                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Register new debtor</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <form action="{{ route('debtor.store') }}" onsubmit="showSpinner()" method="post"
                                class="was-validated">
                                @csrf

                                <div class="card-body">

                                    <label for="name">Debtor name</label>
                                    <input type="text" name="name" class="form-control" id="name" required>

                                    <label for="Address">Address</label>
                                    <input type="text" name="address" class="form-control" id="Address" required>

                                    <label for="phone">Phone number</label>
                                    <input type="text" name="phone" class="form-control" id="phone" required>

                                    <label for="location">Selling location</label>
                                    @if ($sellingCount > 1)
                                        <select name="location" id="location" class="form-control" required>
                                            <option disabled selected>-- Choose Location --</option>
                                            @foreach ($sellings as $selling)
                                                <option value="{{ $selling->id }}">
                                                    -- {{ $selling->location->name }} --
                                                </option>
                                            @endforeach
                                        </select>
                                    @else
                                        <input type="hidden" name="location" id="location" class="form-control"
                                            value="{{ $sellings[0]->selling_id }}">

                                        <input type="text" name="area-copy" id="area-copy" class="form-control"
                                            value="{{ $sellings[0]->location->name }}" readonly>
                                    @endif
                                </div>

                                <div class="card-footer">

                                    <center>
                                        <button class="btn btn-outline-info btn-block"><i
                                                class="fa-solid fa-paper-plane fa-lg"></i> Register</button>
                                    </center>

                                </div>

                            </form>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <div class="card-body table-responsive">

            <table class="table table-stripped table-hover">

                <thead>
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Address</th>
                        <th>Phone</th>
                        <th>Location</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>

                    @foreach ($debtors as $debtor)
                        <tr>
                            <td>{{ $loop->index + 1 }}</td>
                            <td>{{ $debtor->name }}</td>
                            <td>{{ $debtor->address }}</td>
                            <td>{{ $debtor->phone }}</td>
                            <td>{{ $debtor->location->name }}</td>
                            <td>

                                {{-- edit trigger model --}}
                                <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                    data-target="#edit-{{ $debtor->id }}">
                                    <i class="fa-solid fa-pen-to-square fa-lg"></i>
                                </button>

                                <div class="modal fade" id="edit-{{ $debtor->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h5 class="modal-title">Update debtor details</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <form action="{{ route('debtor.update', $debtor->id) }}"
                                                onsubmit="showSpinner()" method="get" class="was-validated">
                                                @csrf

                                                <div class="modal-body">

                                                    <label for="name-{{ $debtor->id }}">Debtor name</label>
                                                    <input type="text" name="name" class="form-control"
                                                        value="{{ $debtor->name }}" id="name-{{ $debtor->id }}">

                                                    <label for="address-{{ $debtor->id }}">Address</label>
                                                    <input type="text" name="address" class="form-control"
                                                        value="{{ $debtor->address }}" id="address-{{ $debtor->id }}">

                                                    <label for="phone-{{ $debtor->id }}">Phone</label>
                                                    <input type="text" name="phone" class="form-control"
                                                        value="{{ $debtor->phone }}" id="phone-{{ $debtor->id }}">

                                                    <label for="location-{{ $debtor->name }}">Selling
                                                        location</label>
                                                    <select name="location" id="location-{{ $debtor->name }}"
                                                        class="form-control" required>
                                                        <option selected value="{{ $debtor->selling_id }}">
                                                            -- {{ $debtor->location->name }} --</option>
                                                        @if ($sellingCount > 1)
                                                            @foreach ($sellings as $selling)
                                                                <option value="{{ $selling->id }}">
                                                                    -- {{ $selling->location->name }} --
                                                                </option>
                                                            @endforeach
                                                        @else
                                                            <option value="{{ $sellings[0]->id }}">
                                                                -- {{ $sellings[0]->location->name }} --</option>
                                                        @endif
                                                    </select>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-outline-info btn-block"><i class="fa-solid fa-paper-plane fa-lg"></i> Update</button>
                                                </div>

                                            </form>
                                        </div>

                                    </div>
                                </div>

                                {{-- delete model --}}
                                <button class="btn btn-outline-danger delete" id="{{ $debtor->id }}">
                                    <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                    <form action="{{ route('debtor.destroy', $debtor->id) }}" onsubmit="showSpinner()"
                                        method="GET" id="deleteform{{ $debtor->id }}">
                                    </form>
                                </button>

                            </td>

                        </tr>
                    @endforeach

                </tbody>

            </table>

        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $(".delete").on("click", function() {
            var id = $(this).attr("id");

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById("deleteform" + id).submit();
                }
            })
        });
    </script>
@endsection

@endsection
