@extends('layouts.master')

@section('content')
    {{-- Content Header (Page header) --}}
    <div class="content-header">

    </div>

    <br>

    {{-- /.content-header --}}

    {{-- Content body (Page Body) --}}
    <div class="content">

        <div class="card">

            <div class="card-header">
                <h3 class="card-title">Customers report</h3>
            </div>


            <div class="card-body">

                <table class="table table-stripped" style="text-align: center" id="customer">

                    <thead>

                        <tr>
                            <th>Check-in date</th>
                            <th>Check-out date</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>

                    </thead>

                    <tbody id="tbody">

                        @foreach ($customers as $customer)
                            <tr>
                                <td>{{ $customer->in }}</td>
                                <td>{{ $customer->out }}</td>
                                <td>{{ $customer->name }}</td>
                                <td>{{ $customer->phone }}</td>
                                <td>{{ $customer->room }}</td>
                                <td>

                                    {{-- View more model --}}
                                    <button type="button" class="btn btn-secondary" data-toggle="modal"
                                        data-target="#view-{{ $customer->id }}">
                                        View More
                                    </button>

                                    <div class="modal fade" id="view-{{ $customer->id }}" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">

                                                <div class="modal-head">
                                                    <center>
                                                        <h4>Customer boking details</h4>
                                                    </center>
                                                </div>

                                                <div class="modal-body">

                                                    <table class="table table-stripped">

                                                        <thead>
                                                            <th>Heading</th>
                                                            <th>Description</th>
                                                        </thead>

                                                        <tbody>

                                                            <tr>
                                                                <td>check-in date</td>
                                                                <td>{{ $customer->in }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Check-out date </td>
                                                                <td>{{ $customer->out }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Customer</td>
                                                                <td>{{ $customer->name }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Nationality</td>
                                                                <td>{{ $customer->nationality }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Religion</td>
                                                                <td>{{ $customer->religion }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Tribe</td>
                                                                <td>{{ $customer->tribe }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Comment</td>
                                                                <td>{{ $customer->comment }}%</td>
                                                            </tr>

                                                            <tr>
                                                                <td>from</td>
                                                                <td>{{ $customer->from }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>To</td>
                                                                <td>{{ $customer->to }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td>Room</td>
                                                                <td>{{ $customer->room }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Price</td>
                                                                <td>{{ $customer->price }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Discount</td>
                                                                <td>{{ $customer->discount }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Net price</td>
                                                                <td>{{ $customer->net }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td> Paid amount</td>
                                                                <td>{{ $customer->paid }}</td>
                                                            </tr>

                                                            <tr>
                                                                <td> Due balance</td>
                                                                <td>{{ $customer->due }}</td>
                                                            </tr>

                                                        </tbody>

                                                    </table>

                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>
                            <th>Check-in date</th>
                            <th>Check-out date</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Room</th>
                            <th>Action</th>
                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>

    </div>
    {{-- /.content --}}

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif
    
    <script>
        $(function() {

            $("#customer").DataTable({

                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

            var net = $("#net").val();
            var paid = $("#paid").val();
            var results = net - paid;
            $("#due").val(results);

        }); //closing DataTables function
    </script>
@endsection

@endsection
