@extends('layouts.master')

@section('content')

    <form action="{{ route('customer.order.profit.and.loss') }}" method="get" class="was-validated">

        <div class="card">

            <div class="card-header">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <select name="type" id="type" class="form-control" style="text-align: center"
                                    required>
                                    <option disabled selected value="">-- Select Type --</option>
                                    <option value="today">--Today --</option>
                                    <option value="set date">--Set date --</option>
                                    <option value="set duration">--Set duration --</option>
                                </select>
                            </td>

                            <td><input type="date" name="start" id="start" class="form-control"
                                    style="text-align: center; display:none" required></td>
                            <td><input type="date" name="end" id="end" class="form-control"
                                    style="text-align: center; display:none" required></td>

                            <td> <button type="submit" id="search" class="btn btn-outline-info"><i
                                        class="fa fa-search fa-lg"></i> Search</button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="card-body">
                <table class="table table-striped table-hover table-bordered" style="text-align: center;">
                    <thead class="thead-dark">
                        <tr>
                            <th scope="col" style="font-weight: bold"><h3>Heading</h3></th>
                            <th scope="col" style="font-weight: bold"><h3>Description</h3></th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                        <td>Start Date</td>
                            <td><h5><b>{{ $start }}</b></h5></td>
                        </tr>

                        <tr>
                            <td>End Date</td>
                            <td><h5><b>{{ $end }}</b></h5></td>
                        </tr>

                        <tr>
                            <td>Total Revenue (Selling Price)</td>
                            <td>
                                <h5><b>{{ number_format($totalrevenue) }}</b></h5>
                            </td>
                        </tr>

                        <tr>
                            <td>Cost Of Good Sold (Buying price)</td>
                            <td>
                                <h5><b>{{ number_format($cogs) }}</b></h5>
                            </td>
                        </tr>

                        <tr>
                            <td>Total Expenditure (Expense)</td>
                            <td>
                                <h5><b>{{ number_format($totalExpenditure) }}</b></h5>
                            </td>
                        </tr>

                        <tr style="{{ $netProfit >= 0 ? 'background-color: lightgreen;' : 'background-color: lightcoral;' }}">
                            <td style="font-weight: bold">Net Profit</td>
                            <td style="font-weight: bold">
                                <h4><b>{{ number_format($netProfit) }}</b></h4>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </form>

    {{-- /.content-body --}}

@endsection

@section('scripts')
    <script>
        $(function() {

            $("#example1").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

            //global variable
            let type = "";
            let start = "";
            let end = "";

            $("#start").on("change", function() {
                start = $(this).val();
            });

            $("#end").on("change", function() {
                end = $(this).val();
            });

            $("#type").on("change", function() {
                type = $(this).val();

                if (type == "today") {
                    $("#start").attr("required", false).fadeOut("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set date") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", false).fadeOut("slow");

                } else if (type == "set duration") {
                    $("#start").attr("required", true).fadeIn("slow");
                    $("#end").attr("required", true).fadeIn("slow");
                }
            });


            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });
        });
    </script>
@endsection

