@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            Pending Customer debts report

            <div class="card-tools">
                <a href="{{ route('cleared.customer.debts.report') }}" class="btn btn-success btn-sm">--View Cleared
                    Debts--</a>

                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>

                <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-bordered table-hover table-striped align-middle shadow-sm"
                    style="text-align: center;">
                    <thead class="thead-dark bg-gradient">
                        <tr>
                            <th style="width: 5%">#</th>
                            <th style="width: 30%">Debtor</th>
                            <th style="width: 20%">Due Balance</th>
                            <th style="width: 20%">Status</th>
                            <th style="width: 15%">Location</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($debts as $debt)
                            @php
                                $sum += $debt->due;
                                $customer = App\Models\Customer::withTrashed()->find($debt->customer_id);
                            @endphp
                            @if ($debt->due > 0)
                                <tr>
                                    <td><span class="badge bg-primary">{{ $loop->index + 1 }}</span></td>
                                    <td>
                                        <strong>{{ $customer->name }}</strong>
                                    </td>
                                    <td>
                                        <a href="{{ route('customer.statement', ['customerId' => $debt->customer_id, 'sellingId' => $debt->selling_id]) }}"
                                            class="text-danger fw-bold" style="text-decoration: underline;">
                                            {{ number_format($debt->due) }}
                                        </a>
                                    </td>
                                    <td>
                                        <span class="badge bg-warning text-dark px-3 py-2"
                                            style="border-radius: 0.5rem; font-size: 1rem;">
                                            <i class="fas fa-exclamation-circle"></i> Pending
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info text-dark">{{ $debt->selling->location->name }}</span>
                                    </td>
                                </tr>
                            @endif
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <div class="d-flex flex-column align-items-center">
                                        <img src="https://cdn-icons-png.flaticon.com/512/4076/4076549.png" alt="No Data"
                                            style="width: 80px; opacity: 0.5;">
                                        <h5 class="mt-3 text-secondary font-weight-bold">No Pending Debts Found</h5>
                                        <p class="text-muted mb-0">There are currently no customers with pending debts.<br>
                                            <span class="small">Once a customer has a pending debt, their record will
                                                appear here based on the data provided.</span>
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot class="bg-light">
                        <tr>
                            <th colspan="2" class="text-end">Total</th>
                            <th class="text-danger fw-bold">{{ number_format($sum) }}</th>
                            <th colspan="2"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    @section('scripts')
        <script>
            $(function() {
                $("#example1").DataTable({
                    "pageLength": 100,
                    "responsive": true,
                    "lengthChange": false,
                    "autoWidth": false,
                    "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]

                }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            });
        </script>
    @endsection
@endsection
