@extends('layouts.master')

@section('content')

    <form action="{{ route('price.list.view') }}" method="get">
        <div class="card">
            <div class="card-header">
                Price List
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle shadow-sm rounded" style="text-align: center;" id="customer">
                        <thead class="table-dark">
                            <tr>
                                <th style="width: 5%">#</th>
                                <th style="width: 15%">Image</th>
                                <th style="width: 50%">Product</th>
                                <th style="width: 20%">Selling Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($units as $unit)
                                <tr>
                                    <td class="fw-bold">{{ $loop->iteration }}</td>
                                    <td>
                                        @if (file_exists(public_path('storage/images/' . $unit->product->image)))
                                            <img height="50" width="90" style="object-fit: cover; border-radius: 8px; border: 2px solid #dee2e6; box-shadow: 0 2px 6px rgba(0,0,0,0.08);" src="{{ asset('storage/images/' . $unit->product->image) }}" alt="Product Image">
                                        @else
                                            <span class="text-muted fst-italic">No Image</span>
                                        @endif
                                    </td>
                                    <td class="text-start">
                                        <span class="fw-semibold">{{ $unit->product->product }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-success fs-6">{{ number_format($unit->selling) }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Image</th>
                                <th>Product</th>
                                <th>Selling Price</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </form>

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#customer").DataTable({
                "pageLength": 100,
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');
        });
    </script>
@endsection

@endsection
