<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmation Page</title>
    {{-- Google Font: Source Sans Pro --}}
    <link rel="stylesheet" href="{{ asset('fonts/font.css') }}">
    {{-- Font Awesome Icons --}}
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/fontawesome.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/fontawesome/css/fontawesome.min.css') }}">
    {{-- Theme style --}}
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
    {{-- Sweet Alert --}}
    <link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css') }}">

    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: black;
        }
        .confirmation-box {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            position: relative;
        }
        .confirmation-box h3 {
            margin-bottom: 20px;
        }
        .confirmation-box a {
            margin: 10px;
        }
        .loading-indicator {
            display: none;
            margin-top: 20px;
        }
    </style>
</head>
<body>

    <div class="confirmation-box">
        <img src="{{ asset('dist/img/warning.jpg') }}" alt="Confirmation Image" style="width: 100px; height: 100px; border-radius: 50%; margin-bottom: 20px;">
        <h3><b>Your are about to execute a kill code, is the database secured?</b></h3>
        <a href="{{ route('home') }}" class="btn btn-warning">
            <i class="fas fa-arrow-left"></i> No, Go Back
        </a>
        <a href="#" id="continueButton" class="btn btn-success">
            <i class="fas fa-check"></i> Yes, Continue
        </a>

        <!-- Loading Indicator -->
        <div id="loadingIndicator" class="loading-indicator">
            <i class="fas fa-spinner fa-spin fa-2x"></i>
            <p>Processing, please wait...</p>
        </div>
    </div>

    <script>
        document.getElementById('continueButton').addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default link behavior
            
            var loadingIndicator = document.getElementById('loadingIndicator');
            loadingIndicator.style.display = 'block';

            // Simulate process completion after 3 seconds
            setTimeout(function() {
                window.location.href = "{{ route('seed.confirmation') }}"; // Redirect to seed route
            }, 3000); // Adjust time as needed
        });
    </script>

</body>
</html>
