@extends('layouts.master')

@section('content')

    <style>
        .grid-container {
            display: grid;
            grid-template-columns: auto auto auto;
            background-color: lightgray;
            padding: 10px;
        }

        .grid-item {
            background-color: rgba(255, 255, 255, 0.8);
            border: 1px solid rgba(0, 0, 0, 0.8);
            padding: 20px;
            font-size: 15px;
            text-align: center;
        }
    </style>

    <div class="card">
        <form action="{{ route('cancel.order') }}" method="get" class="was-validated">
            <div class="card-header">
                <div class="row">
                    <div class="col-5">
                        <select name="table" class="form-control text-center" id="table" required>
                            <option disabled selected value="">-- Select Table --</option>
                            @foreach ($tables as $table)
                                <option value="{{ $table->id }}">-- {{ $table->name }} --</option>
                            @endforeach
                        </select>
                        @error('table')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-5">
                        <select name="waiter" class="form-control text-center" id="waiter" required>
                            <option disabled selected value="">-- Select Waiter --</option>
                             <option value="0">-- QR Code --</option>
                            @foreach ($waiters as $waiter)
                                <option value="{{ $waiter->id }}">-- {{ $waiter->name }} --</option>
                            @endforeach
                        </select>
                        @error('waiter')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-2">
                        <button type="button" class="btn btn-primary" id="get-bill"><i class="fas fa-receipt"></i> Get Bill</button>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <div class="container-fluid">
                    <table class="table table-bordered table-hover align-middle text-center shadow-sm">
                        <thead class="table-dark">
                            <tr>
                                <th style="width: 5%">
                                    <i class="fa fa-hashtag me-1"></i>
                                </th>
                                <th style="width: 20%">
                                    <i class="fa fa-box-open me-1"></i> Product
                                </th>
                                <th style="width: 10%">
                                    <i class="fa fa-balance-scale me-1"></i> Unit
                                </th>
                                <th style="width: 10%">
                                    <i class="fa fa-money-bill-wave me-1"></i> Price
                                </th>
                                <th style="width: 15%">
                                    <i class="fa fa-sort-numeric-up me-1"></i> Qty
                                </th>
                                <th style="width: 10%">
                                    <i class="fa fa-calculator me-1"></i> Amount
                                </th>
                                <th style="width: 15%">
                                    <i class="fa fa-cogs me-1"></i> Action
                                </th>
                            </tr>
                        </thead>

                        <tbody id="tbody">
                            <!-- Summary Row -->
                            <tr id="jumla" class="table-light fw-bold">

                            </tr>

                            <!-- Summary Row -->
                            <tr class="table-light fw-bold">
                                <td colspan="6">&nbsp;</td>
                                <td>
                                     <input type="hidden" name="sale-id" id="sale-id"
                                        class="form-control text-center fw-bold bg-light" readonly>

                                    <input type="text" name="total" id="total"
                                        class="form-control text-center fw-bold bg-light" placeholder="Total" readonly>
                                </td>
                            </tr>

                            <!-- Confirm Button Row -->
                            <tr>
                                <td colspan="6">&nbsp;</td>
                                <td colspan="2">
                                    <button type="submit" class="btn btn-success w-100 shadow-sm">
                                        <i class="fa fa-paper-plane me-1"></i> Confirm
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer">

            </div>
        </form>
    </div>

    @include('patial.keyboard')

@section('scripts')
    <script>
        $(document).ready(function() {

            const formatter = new Intl.NumberFormat('en-US'); // You can change 'en-US' to your locale

            let index = 1;

            document.getElementById('get-bill').addEventListener('click', function(e) {
                e.preventDefault();

                let tableId = document.getElementById('table').value;
                let waiterId = document.getElementById('waiter').value;

                if (!tableId || !waiterId) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Missing Fields',
                        text: 'Please select both Table and Waiter before proceeding.',
                    });
                    return;
                }

                // Show loading indicator
                Swal.fire({
                    title: 'Fetching Bill...',
                    html: 'Please wait while we retrieve the bill details.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading(); // built-in loader animation
                    },
                    background: '#f7f9fb',
                    customClass: {
                        popup: 'swal2-border-radius'
                    }
                });

                $.ajax({
                    url: "{{ route('get.waiter.bill') }}",
                    type: "GET",
                    data: {
                        tableId: tableId,
                        waiterId: waiterId
                    },
                    success: function(response) {
                        console.log(response);
                        $("#jumla").empty();

                        // Check if the response object is empty
                       if (isEmptyObject(response)) {
                            Swal.fire({
                                icon: 'info',
                                title: 'No Bill Found',
                                background: '#f0f8ff',
                                toast: true,
                                position: 'top-end',
                                timer: 3000,
                                showConfirmButton: false,
                                timerProgressBar: true,
                                customClass: {
                                    popup: 'swal2-border-radius'
                                }
                            });
                            return; // Exit the function
                        }

                        response.sold_items.forEach((item) => {
                            let tr = `
                                        <tr id="tr${index}">
                                            <td> ${index} </td>
                                            <td>
                                                <input type="hidden" name="id[]" value="${item.product.id}" id="id${index}" class="form-control id" readonly>
                                                <input type="hidden" name="location[]" value="${response.selling.location.id}" id="location${index}" class="form-control" readonly>
                                                ${item.product.product}
                                            </td>
                                            <td><input type="text" name="unit[]" value="${item.unit.name}" id="unit${index}" class="form-control text-center unit" readonly></td>
                                            <td><input type="text" name="price[]" value="${item.price}" id="price${index}" class="form-control text-center price" readonly></td>
                                            <td style="display:flex">
                                                <button type="button" class="btn btn-warning decrement" id="${index}"><i class="fas fa-minus"></i></button>
                                                <input type="text" name="qty[]" value="${item.qty}" id="qty${index}" class="form-control text-center qty" readonly required>
                                                <button type="button" class="btn btn-primary increment" id="increment${index}"><i class="fas fa-plus"></i></button>
                                            </td>
                                            <td><input type="text" name="amount[]" value="${item.amount}" id="amount${index}" class="form-control text-center amount" readonly></td>
                                            <td><button type="button" class="btn btn-danger removeRow" id="${index}"><i class="fas fa-trash-alt"></i></button></td>
                                        </tr>
                                    `;

                            $("#jumla").before(tr);
                            index++;
                            total();
                        });

                         $("#sale-id").val(response.id);

                        // Close loading modal
                        Swal.close();

                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: "Bill Fetched and Listed.",
                            background: '#e6ffed',
                            showConfirmButton: false,
                            timer: 2500,
                            timerProgressBar: true,
                            position: 'top-end',
                            toast: true,
                            customClass: {
                                popup: 'swal2-border-radius'
                            }
                        });
                    },
                    error: function(xhr) {
                        Swal.close();

                        Swal.fire({
                            icon: 'error',
                            title: 'Error.',
                            text: 'Failed to load bill',
                            background: '#ffeaea',
                            showConfirmButton: false,
                            timer: 4000,
                            timerProgressBar: true,
                            position: 'top-end',
                            toast: true,
                            customClass: {
                                popup: 'swal2-border-radius'
                            }
                        });
                    }
                });
            });

            // Check if the response object is empty
            function isEmptyObject(obj) {
                return Object.keys(obj).length === 0;
            }

            // Remove row function
            $(document).on("click", ".removeRow", function() {
                let id = $(this).attr("id");
                $("#tr" + id).remove();
                total();
            });

            // Increment QTY function
            $(document).on("click", ".increment", function() {
                let id = $(this).attr("id").replace("increment", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                qtyInput.val(qty + 1);
                updateAmount(id);
            });

            // Decrement QTY function
            $(document).on("click", ".decrement", function() {
                let id = $(this).attr("id").replace("decrement", "");
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());
                if (qty > 1) {
                    qtyInput.val(qty - 1);
                    updateAmount(id);
                }
            });

            function updateAmount(id) {
                let qtyInput = $("#qty" + id);
                let qty = parseInt(qtyInput.val());

                let priceInput = $("#price" + id);
                // Remove commas from the price input and convert it to a float
                let price = parseFloat(priceInput.val().replace(/,/g, ''));

                let amountInput = $("#amount" + id);
                let amount = qty * price;

                // Format the amount with commas
                amountInput.val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));

                // Call the total function to update the total amount
                total();
            }

            function total() {
                let amount = 0;
                let grandtotal = 0;

                $(".amount").each(function() {
                    // Ensure the number is properly parsed
                    amount += Number($(this).val().replace(/,/g, ''));
                });

                // Format total with commas
                $("#total").val(amount.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }));
            }
        });
    </script>
@endsection

@endsection
