@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            Booking & check in.
        </div>

        <div class="card-body">
            <table class="table table-stripped table-hover" style="border: 1px solid #dee2e6; border-radius: 5px; box-shadow: 0 2px 4px rgba(0,0,0,0.1), 0 8px 16px rgba(0,0,0,0.1)">
                <thead style="background-color: #f8fafc; border-bottom: 2px solid #dee2e6">
                    <tr>
                        <th>S/N</th>
                        <th>Room</th>
                        <th>Price</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                <tbody>
                    @if ($roomCount > 0)
                        @foreach ($rooms as $room)
                            <tr style="border-bottom: 1px solid #dee2e6">
                                <td>{{ $loop->index + 1 }}</td>
                                <td>{{ $room->name }}</td>
                                <td>{{ number_format($room->price) }}</td>
                                <td style="vertical-align: middle">
                                    {{-- delete model --}}
                                    <button type="button" class="btn btn-outline-success" data-toggle="modal"
                                        data-target="#booking-{{ $room->id }}" style="border-radius: 5px">
                                        <i class="fas fa-plus"></i> Booking | Check-in
                                    </button>

                                    <div class="modal fade" id="booking-{{ $room->id }}" tabindex="-1" aria-labelledby="booking-{{ $room->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content" style="border-radius: 5px">

                                                <div class="modal-header" style="background-color: #f8fafc; border-bottom: 2px solid #dee2e6">
                                                    <h5 class="modal-title">{{ $room->name }}</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>

                                                <form action="{{ route('booking.store', $room->id) }}" method="post"
                                                    class="was-validated">
                                                    @csrf
                                                    <div class="modal-body">
                                                        <label for="in-date">In date</label>
                                                        <input type="date" name="in" id="in-date"
                                                            value="{{ date('Y-m-d') }}" class="form-control" required>


                                                        <label for="room">Room</label>
                                                        <input type="text" name="room" id="room"
                                                            value="{{ $room->name }}" class="form-control" readonly>

                                                        <label for="price ">Room Price</label>
                                                        <input type="text" name="price" id="price"
                                                            value="{{ $room->price }}" class="form-control" readonly>

                                                        <label for="customer">Customer</label>
                                                        <input type="text" name="customer" id="name"
                                                            class="form-control" required>

                                                        <label for="phone">Phone</label>
                                                        <input type="text" name="phone" id="phone"
                                                            class="form-control" required>

                                                        <label for="comment">Comment</label>
                                                        <input type="text" name="comment" id="comment"
                                                            class="form-control">

                                                        <label for="paid">Paid amount</label>
                                                        <input type="number" name="paid" id="paid"
                                                            class="form-control" value="0">

                                                        <label for="account">Account</label>
                                                        <select name="account" id="account" class="form-control">
                                                            <option disabled selected value="">-- Choose Account --
                                                            </option>
                                                            @foreach ($accounts as $account)
                                                                <option value="{{ $account->id }}">
                                                                    -- {{ $account->type }} - {{ $account->name }} --
                                                                </option>
                                                            @endforeach
                                                        </select>

                                                        <label for="status">Status</label>
                                                        <select name="status" id="status" class="form-control" required>
                                                            <option disabled selected value="">Choose status
                                                            </option>
                                                            <option value="1">-- Check In --</option>
                                                            <option value="2">-- Booking --</option>
                                                        </select>
                                                    </div>

                                                    <div class="modal-footer" style="border-top: 2px solid #dee2e6">
                                                        <button class="btn btn-outline-info btn-block" style="border-radius: 5px"><i class="fas fa-paper-plane"></i> Confirm --</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr style="border-bottom: 1px solid #dee2e6">
                            <td colspan="3">
                                <center> Vyumba vimeisha kwa leo..</center>
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script>
        $("#customer").DataTable({
            "pageLength": 100,
            "responsive": true,
            "lengthChange": false,
            "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
        }).buttons().container().appendTo('#customer_wrapper .col-md-6:eq(0)');

        $("#success").fadeIn("slow");
        setTimeout(function() {
            $("#success").fadeOut("slow")
        }, 3000);

        // $("#paid").on("keyup", function() {
        //     let paid = $(this).val();
        //     let roomPrice = $("#price").val();
        //     if (paid > 0) {
        //         $("#account-div").fadeIn("slow");
        //         $("#account").attr("required", true);
        //     } else if (paid > 0 || paid === "") {
        //         $("#account-div").fadeOut("slow");
        //         $("#account").attr("required", false);
        //     }
        // });
    </script>
@endsection

@endsection
