@extends('layouts.master')

@section('content')

    <div class="card table-responsive"
        style="width: 50%; margin-left: 25%; margin-top: 5%; border-radius: 20px; box-shadow: 0px 0px 10px 5px rgba(0,0,0,0.5)">
        <div class="card-header"
            style="border-radius: 20px 20px 0px 0px; background-color: #007bff; color: white; font-size: 20px">Generate &
            print Barcode
        </div>

        <div class="card-body" style="padding: 40px">

            <label for="location" style="font-size: 20px">Location</label>
            <select name="location" id="location" class="form-control text-center" style="font-size: 18px;" required>
                <option disabled selected>-- Choose Location --</option>
                @foreach ($sellings as $selling)
                    <option value="{{ $selling->location_id }}">-- {{ $selling->location->name }} --
                    </option>
                @endforeach
            </select>

            <label for="search" style="font-size: 20px">Product</label>
            <input type="search" id="search" class="form-control text-center search"
                placeholder="Enter product name or barcode.." style="font-size: 18px">
            <div id="list"
                style="display:none; position: absolute; z-index: 10; width: 87%; border-radius: 0 0 0.5rem 0.5rem; box-shadow: 0 4px 12px rgba(0,0,0,0.12);"
                class="bg-white border border-primary">
                <ol id="results" class="list-group list-group-flush"></ol>
            </div>

            <div id="barcodeimage" style="margin-top: 1%; margin-bottom: 1%">

            </div>

            <div class="card-footer">
                <center>
                    <button class="btn btn-primary" id="print" style="font-size: 20px; border-radius: 10px"><i
                            class="fas fa-print"></i> Print Barcode</button>
                </center>
            </div>
        </div>
    </div>

@section('scripts')
    <script>
        $(document).ready(function() {
            var location = $("#location").val();
            $("#location").on("change", function() {
                location = $(this).val();
            });

            $(".search").on("keyup", function() {
                var query = $(this).val();
                var ujumbe = "No suggestions..";

                $.ajax({
                    url: "{{ route('get.location.product') }}",
                    method: "get",
                    data: {
                        'query': query,
                        'locationId': location,
                    },
                    success: function(response) {
                        ajaxResults = response;

                        $("#results").empty();

                       // If somthing is typed.
                        if (query != "") {
                            // If ajax response returns nothing.
                            if (ajaxResults.length === 0) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="btn btn-outline-secondary form-control items">' +
                                    ujumbe + '</button></li>');
                            }
                            // If ajax response returns sothing.
                            for (var i = 0; i < ajaxResults.length; i++) {
                                $("#list").fadeIn("slow");
                                $("#results").append(
                                    '<li><button type="button" class="form-control items btn btn-outline-secondary" id="' +
                                    [i] + '" >' +
                                    ajaxResults[i].product + ' | ' +
                                    ajaxResults[i].stock[0]
                                    .qty + ' ' + ajaxResults[i].unit[0].unit.name +
                                    '</button></li>');
                            }
                        }
                    }
                });
            });


            function calculateEAN13CheckDigit(barcode) {
                if (barcode.length !== 12) {
                    return null;
                }
                let sum = 0;
                for (let i = 0; i < 12; i++) {
                    let digit = parseInt(barcode[i]);
                    sum += (i % 2 === 0) ? digit : digit * 3;
                }
                let checkDigit = (10 - (sum % 10)) % 10;
                return checkDigit;
            }


            // ✅ This runs once, no matter how many times you type
            $(document).on("click", ".items", function() {
                var id = $(this).attr("id");
                var productId = ajaxResults[id].id;
                var product = ajaxResults[id].product;
                var price = new Intl.NumberFormat('en-US', {
                    maximumFractionDigits: 2
                }).format(ajaxResults[id].unit[0].selling);
                var barcode = ajaxResults[id].barcode;

                var continueFlow = function() {
                    var barcodeUrl = "https://barcode.tec-it.com/barcode.ashx?data=" +
                        barcode + "&code=EAN13&translate-esc=on";

                    $("#search").empty();
                    $("#barcodeimage").empty();
                    $("#search").val(product);

                    $("#barcodeimage").html(
                        '<center>' +
                        '<p style="margin-bottom: 0px; margin-top: 0px"><b>' +
                        product + ' - ' + price + ' </b></p>' +
                        '<img src="' + barcodeUrl + '" alt="barcode" />' +
                        '</center>'
                    );

                    $("#list").fadeOut("slow");
                };

                if (barcode.length === 13) {
                    let expectedCheckDigit = calculateEAN13CheckDigit(barcode.substring(0, 12));
                    if (parseInt(barcode[12]) !== expectedCheckDigit) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Incorrect check digit detected!',
                            text: 'Fixing barcode...',
                            showConfirmButton: false,
                            timer: 2000
                        });
                        barcode = barcode.substring(0, 12) + expectedCheckDigit;
                    }
                    continueFlow();

                } else if (barcode.length < 12) {
                    barcode = barcode.padStart(12, '0');
                    let correctCheckDigit = calculateEAN13CheckDigit(barcode);
                    barcode += correctCheckDigit;

                    $.ajax({
                        url: "{{ route('products.update.barcode') }}",
                        method: 'POST',
                        data: {
                            product_id: productId,
                            barcode: barcode,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success === false) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Failed!',
                                    text: response.message ||
                                        'Could not update barcode.',
                                    showConfirmButton: true
                                });
                                return;
                            } else {
                                Swal.fire({
                                    icon: 'info',
                                    title: 'Barcode Padded',
                                    text: `Barcode was too short. Padded and fixed: ${barcode}`,
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                                continueFlow();
                            }
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Server Error!',
                                text: 'Something went wrong.',
                                showConfirmButton: true
                            });
                            return;
                        }
                    });

                } else if (barcode.length === 12) {
                    let correctCheckDigit = calculateEAN13CheckDigit(barcode);
                    barcode += correctCheckDigit;
                    continueFlow();

                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Invalid barcode length!',
                        text: 'EAN-13 barcodes must be 12 or 13 digits.',
                        showConfirmButton: true
                    });
                    return;
                }
            });

            $("#print").on("click", function() {
                var divContents = document.getElementById("barcodeimage").innerHTML;
                var a = window.open('', '', 'height=500, width=500');
                a.document.write('<html>');
                a.document.write('<body>');
                a.document.write(divContents);
                a.document.write('</body></html>');
                a.document.close();
                a.print();
            });
        });
    </script>
@endsection

@endsection
