@extends('layouts.master')

@section('content')

    <div class="card">
        <div class="card-header">
            <button type="button" id="deleteall" class="btn btn-outline-danger"><i class="fa-solid fa-trash-alt"></i> Delete
                selected</button>

            <!-- Button trigger modal -->
            <button type="button" class="btn btn-outline-info" data-toggle="modal" data-target="#addasset">
                <i class="fa-solid fa-plus"></i>
                Add Asset
            </button>

            <!-- Modal -->
            <div class="modal fade" id="addasset" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">Add asset</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <form action="{{ Route('asset.store') }}" method="post" class="was-validated">
                            @csrf

                            <div class="modal-body">

                                <table class="table table-striped" id="table">

                                    <thead style="text-align: center;">

                                        <tr>
                                            <th scope="col" style="width:2%">#</th>
                                            <th scope="col">Asset</th>
                                            <th scope="col">Category</th>
                                            <th scope="col">Value</th>
                                            <th scope="col"><button type="button" class="btn btn-outline-info"
                                                    id="addRow"><i class="fa-solid fa-plus"></i></button>
                                            </th>
                                        </tr>

                                    </thead>

                                    <tbody id="tbody">

                                    </tbody>

                                </table>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fa-solid fa-times-circle"></i> Close</button>
                                <button type="submit" class="btn btn-outline-info"><i
                                        class="fa-solid fa-paper-plane"></i>Add Asset</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body table-responsive">
            <table class="table table-stripped table-hover">
                <thead>
                    <tr>
                        <th style="width:5%"><input type="checkbox" id="checkall"></th>
                        <th>S/N</th>
                        <th>Assets</th>
                        <th>Category</th>
                        <th>Value</th>
                        <th style="width: 20%">Action</th>
                    </tr>
                </thead>

                @foreach ($assets as $asset)
                    @php
                        $category_name = App\Models\AssetCategory::find($asset->asset_category_id)->value('name');
                    @endphp
                    <tr>
                        <td><input type="checkbox" class="selected" id="{{ $asset->id }}"></td>
                        <td>{{ $loop->index + 1 }}</td>
                        <td>{{ $asset->name }}</td>
                        <td>{{ $category_name }}</td>
                        <td>{{ number_format($asset->value) }}</td>
                        <td>
                            {{-- delete model --}}
                            <button class="btn btn-outline-danger delete" id="{{ $asset->id }}">
                                <i class="fa fa-trash-alt fa-lg" aria-hidden="true"></i>

                                <form action="{{ route('asset.destroy', $asset->id) }}" method="GET"
                                    id="deleteform{{ $asset->id }}">
                                </form>
                            </button>

                            <button type="button" class="btn btn-outline-info" data-toggle="modal"
                                data-target="#edit-{{ $asset->id }}">
                                <i class="fa-solid fa-pen-to-square fa-lg"></i>
                            </button>

                            <div class="modal fade" id="edit-{{ $asset->id }}" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">

                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit asset</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>

                                        <form action="{{ route('asset.update', $asset->id) }}" method="post"
                                            class="was-validated">
                                            @csrf
                                            <div class="modal-body">

                                                <div class="form-group">
                                                    <label for="1">Unit name</label>
                                                    <input type="text" name="name" id="1"
                                                        value="{{ $asset->name }}" class="form-control" required>
                                                </div>

                                                <div class="form-group">
                                                    <label for="2">Category</label>
                                                    <select name="category" id="2" class="form-control" required>
                                                        <option selected value="{{ $asset->asset_category_id }}">
                                                            -- {{ $category_name }} --</option>
                                                        @foreach ($categories as $category)
                                                            <option value="{{ $category->id }}">-- {{ $category->name }}
                                                                --
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label for="3">Value</label>
                                                    <input type="number" name="value" id="3"
                                                        value="{{ $asset->value }}" class="form-control" required>
                                                </div>

                                                <div class="modal-footer">
                                                    <button class="btn btn-outline-info btn-block"><i
                                                            class="fa-solid fa-paper-plane"></i> Save Updates</button>
                                                </div>
                                        </form>

                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>

@section('scripts')
    @if (session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->get('success') }}',
                showConfirmButton: false,
                timer: 2000
            })
        </script>
    @endif

    <script type="text/javascript">
        $(document).ready(function() {

            var index = 1;

            // add row
            $("#addRow").on("click", function(e) {

                e.preventDefault();

                var tr =

                    `<tr id= "tr${index}">

                    <td>${index}</td>

                    <td><input type="text" name="name[]" class="form-control" placeholder="Enter asset name" style = "text-align: center;" required></td>

                    <td><select name="category[]" class="form-control" style="text-align: center">
                                    <option selected disabled value="">-- Category --</option>
                                   @foreach ($categories as $category)
                                    <option value="{{ $category->id }}">-- {{ $category->name }} --</option>
                                   @endforeach
                                </select></td>

                                <td><input type="number" name="value[]" class="form-control" placeholder="Enter value asset" style = "text-align: center;" required></td>

                    <td><button type="button"id="${index}"
                    class="btn btn-outline-danger removeRow"><i class="fa fa-trash-alt"></i></button></td>

                    </tr>`;

                $("#tbody").append(tr);
                index++;

                $(".removeRow").on("click", function() {

                    var id = $(this).attr("id");

                    $("#tr" + id).remove();
                });

            });

            $("#checkall").on("click", function() {
                if ($(this).is(':checked', true)) {
                    $(".selected").prop('checked', true);
                } else {
                    $(".selected").prop('checked', false);
                }
            });

            $("#deleteall").on("click", function() {
                var selected = [];
                $(".selected:checked").each(function() {
                    selected.push($(this).attr("id"));
                });

                if (selected.length == 0) {

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Select atleast one item!!',
                    });

                } else {

                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('units.bulk.delete') }}",
                                method: "GET",
                                data: {
                                    'ids': selected
                                },
                                success: function(data) {
                                    window.location.reload(true);
                                }
                            });

                            $(document).ready(function() {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'deleted successfully!!',
                                    showConfirmButton: false,
                                    timer: 2000
                                });
                            });
                        }
                    });

                }

            });

            $(".delete").on("click", function() {
                var id = $(this).attr("id");

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById("deleteform" + id).submit();
                    }
                })
            });

        });
    </script>
@endsection

@endsection
