<?php

namespace Database\Seeders;

use App\Models\License;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class LicenseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $start_date = Carbon::now(); // Get the current date and time.
        $end_date = $start_date->copy()->addWeek();
        License::create([
            'key' => '000000',
            'location' => 1,
            'tra' => null,
            'starts_at' => $start_date->toDateString(),
            'expires_at' => $end_date->toDateString(),
            'h_starts_at' => null,
            'h_expires_at' => null,
        ]);
    }
}
