<?php

namespace Database\Seeders;

use App\Models\ExpenseCategory;
use Illuminate\Database\Seeder;

class ExpensesCategorySeeder extends Seeder
{
    public function run()
    {
        $categories = [

            /*
            |--------------------------------------------------------------------------
            | OPERATING EXPENSES
            |--------------------------------------------------------------------------
            */
            ['name' => 'Umeme', 'expense_type' => 'operating'],
            ['name' => 'Maji', 'expense_type' => 'operating'],
            ['name' => 'Chakula', 'expense_type' => 'operating'],
            ['name' => 'Usafiri / Mafuta', 'expense_type' => 'operating'],
            ['name' => 'Takataka', 'expense_type' => 'operating'],
            ['name' => 'Ufundi & Ukarabati', 'expense_type' => 'operating'],
            ['name' => 'Vibarua', 'expense_type' => 'operating'],
            ['name' => 'Posho', 'expense_type' => 'operating'],
            ['name' => 'Dharura', 'expense_type' => 'operating'],
            ['name' => 'Ulinzi', 'expense_type' => 'operating'], // <-- Add this line

            /*
            |--------------------------------------------------------------------------
            | ADMINISTRATIVE EXPENSES
            |--------------------------------------------------------------------------
            */
            ['name' => 'Mishahara (Admin)', 'expense_type' => 'administrative'],
            ['name' => 'Kodi ya Ofisi', 'expense_type' => 'administrative'],
            ['name' => 'Intaneti & Simu', 'expense_type' => 'administrative'],
            ['name' => 'Stationery & Vifaa vya Ofisi', 'expense_type' => 'administrative'],
            ['name' => 'Leseni & Vibali', 'expense_type' => 'administrative'],
            ['name' => 'Bima', 'expense_type' => 'administrative'],
            ['name' => 'Ada za Benki', 'expense_type' => 'administrative'],
            ['name' => 'Huduma za Kisheria & Ukaguzi', 'expense_type' => 'administrative'],

            /*
            |--------------------------------------------------------------------------
            | SELLING & DISTRIBUTION EXPENSES
            |--------------------------------------------------------------------------
            */
            ['name' => 'Matangazo & Marketing', 'expense_type' => 'selling'],
            ['name' => 'Gharama za Usambazaji', 'expense_type' => 'selling'],
            ['name' => 'Commission', 'expense_type' => 'selling'],
            ['name' => 'Packaging', 'expense_type' => 'selling'],

            /*
            |--------------------------------------------------------------------------
            | FINANCE EXPENSES
            |--------------------------------------------------------------------------
            */
            ['name' => 'Riba ya Mkopo', 'expense_type' => 'finance'],
            ['name' => 'Ada za Mkopo', 'expense_type' => 'finance'],
            ['name' => 'Hasara ya Kubadilisha Fedha (Forex Loss)', 'expense_type' => 'finance'],
            ['name' => 'Ada za Mobile Money', 'expense_type' => 'finance'],

            /*
            |--------------------------------------------------------------------------
            | STAFF WELFARE & COMPLIANCE
            |--------------------------------------------------------------------------
            */
            ['name' => 'Mafunzo ya Wafanyakazi', 'expense_type' => 'welfare'],
            ['name' => 'Sare za Wafanyakazi', 'expense_type' => 'welfare'],
            ['name' => 'Matibabu ya Wafanyakazi', 'expense_type' => 'welfare'],
            ['name' => 'Michango ya NSSF / NHIF', 'expense_type' => 'welfare'],

            /*
            |--------------------------------------------------------------------------
            | CAPITAL EXPENSES (ASSETS)
            |--------------------------------------------------------------------------
            */
            ['name' => 'Vifaa vya Ofisi (Assets)', 'expense_type' => 'capital'],
            ['name' => 'Samani', 'expense_type' => 'capital'],
            ['name' => 'Magari', 'expense_type' => 'capital'],
            ['name' => 'Mashine & Vifaa Vikubwa', 'expense_type' => 'capital'],

            /*
            |--------------------------------------------------------------------------
            | EXTRAORDINARY / ONE-OFF EXPENSES
            |--------------------------------------------------------------------------
            */
            ['name' => 'Hasara ya Wizi', 'expense_type' => 'extraordinary'],
            ['name' => 'Adhabu & Faini', 'expense_type' => 'extraordinary'],
            ['name' => 'Hasara ya Majanga', 'expense_type' => 'extraordinary'],
        ];

        foreach ($categories as $category) {
            ExpenseCategory::updateOrCreate(
                ['name' => $category['name']],
                ['expense_type' => $category['expense_type']]
            );
        }
    }
}
