<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable(); // The subscriber/customer
            $table->string('transaction_id')->unique(); // DPO transaction reference
            $table->string('payment_method')->default('DPO'); // e.g., DPO, PayPal, Card
            $table->decimal('amount', 15, 2); // Payment amount
            $table->string('currency', 10)->default('TZS'); // Currency
            $table->string('status')->default('pending'); // pending, completed, failed
            $table->timestamp('paid_at')->nullable(); // When the payment was successful
            $table->text('response')->nullable(); // Store raw response from DPO
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
