<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        $tables = [
            'accounts',
            'transactions',
            'suppliers',
            'customers',
            'post_expenses',
            'users',
            'services',
            'profomas',
            'purchase_orders',
            'debts',
            'supplier_debts',
            'purchases',
            'sales',
            'tables',
            'waiters',
            'production_orders',
        ];

        foreach ($tables as $tableName) {
            Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                if (!Schema::hasColumn($tableName, 'selling_id')) {
                    $table->integer('selling_id')->after('id');
                    // Optional: Add a foreign key
                    // $table->foreign('selling_id')->references('id')->on('sellings')->nullOnDelete();
                }
            });
        }
    }

    public function down(): void
    {
        $tables = [
            'accounts',
            'transactions',
            'suppliers',
            'customers',
            'post_expenses',
            'users',
            'services',
            'purchase_orders',
            'debts',
            'supplier_debts',
            'purchases',
            'sales',
            'tables',
            'waiters',
            'production_orders',
        ];

        foreach ($tables as $tableName) {
            Schema::table($tableName, function (Blueprint $table) use ($tableName) {
                if (Schema::hasColumn($tableName, 'selling_id')) {
                    $table->dropColumn('selling_id');
                }
            });
        }
    }
};
