<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('selling_id');
            $table->unsignedBigInteger('creditor_id')->nullable();
            $table->unsignedBigInteger('debtor_id')->nullable();
            $table->unsignedBigInteger('account_id');
            $table->integer('principle');
            $table->date('rdate');
            $table->string('purpose');
            $table->integer('intrest');
            $table->integer('tamount');
            $table->integer('installment');
            $table->integer('iamount');
            $table->integer('paid');
            $table->integer('next_installment_amount');
            $table->string('next_installment_date');
            $table->string('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loans');
    }
};
