<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supplier_debts', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->unsignedBigInteger('selling_id');
            $table->unsignedBigInteger('purchase_id')->nullable();
            $table->unsignedBigInteger('supplier_id');
            $table->unsignedBigInteger('account_id')->nullable();
            $table->bigInteger('opening_balance');
            $table->bigInteger('amount');
            $table->bigInteger('discount')->nullable();
            $table->bigInteger('paid');
            $table->bigInteger('due');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_debts');
    }
};
