<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('duplicate_products', function (Blueprint $table) {
            $table->id();
            $table->string('barcode')->nullable();
            $table->string('product');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->integer('buying');
            $table->string('supplier')->nullable();
            $table->string('location');
            $table->string('minunit')->nullable();
            $table->integer('mincont')->nullable();
            $table->integer('minqty')->nullable();
            $table->integer('qty')->nullable();
            $table->string('exp')->nullable();
            $table->string('expnot')->nullable();
            $table->string('unit1')->nullable();
            $table->integer('unitcont1')->nullable();
            $table->integer('selling1')->nullable();
            $table->string('unit2')->nullable();
            $table->integer('unitcont2')->nullable();
            $table->integer('selling2')->nullable();
            $table->string('unit3')->nullable();
            $table->integer('unitcont3')->nullable();
            $table->integer('selling3')->nullable();
            $table->string('unit4')->nullable();
            $table->integer('unitcont4')->nullable();
            $table->integer('selling4')->nullable();
            $table->string('batch_no')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('duplicate_products');
    }
};
