<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Eloquent\SoftDeletes;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('location_id');
            $table->unsignedBigInteger('unit_id')->nullable();

            $table->integer('qty')->default(0);

            // Batch & Expiry
            $table->string('batch_no')->nullable();
            $table->date('exp_date')->nullable();
            $table->string('exp_not')->nullable();

            // Minimum stock alerts
            $table->integer('min_cont')->nullable();
            $table->integer('min_qty')->nullable();

            $table->softDeletes();
            $table->timestamps();

            // Index for fast lookup
            $table->index(['product_id', 'location_id', 'batch_no']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stocks');
    }
};
