<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('licenses', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('key')->nullable();
            $table->integer('device');
            $table->integer('location');
            $table->integer('tra')->nullable();
            $table->date('starts_at');
            $table->date('expires_at');
            $table->date('h_starts_at')->nullable();
            $table->date('h_expires_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('licenses');
    }
};
