<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sold_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_id');  // FK to sales
            $table->unsignedBigInteger('product_id'); // FK to products
            $table->unsignedBigInteger('unit_id'); // FK to units
            $table->integer('cont');  // conversion factor
            $table->decimal('price', 12, 2); // price per unit
            $table->integer('qty'); // quantity sold
            $table->decimal('amount', 12, 2); // total amount
            $table->decimal('discount', 12, 2)->nullable(); // discount per item
            $table->string('batch_no')->nullable(); // optional: batch number
            $table->timestamps();

            // Optional foreign keys
            $table->foreign('sale_id')->references('id')->on('sales')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products');
            $table->foreign('unit_id')->references('id')->on('units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sold_items');
    }
};
