<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('selling_id');
            $table->string('in_date');
            $table->integer('days');
            $table->string('customer');
            $table->string('phone');
            $table->string('comment');
            $table->integer('room_id');
            $table->bigInteger('total');
            $table->bigInteger('paid');
            $table->bigInteger('due');
            $table->string('account_id')->nullable();
            $table->integer('status');
            $table->string('total_bill')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bookings');
    }
};
