<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_profiles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('selling_id');
            $table->string('exp_date')->nullable();
            $table->string('device')->nullable();
            $table->string('address');
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->string('tin')->nullable();
            $table->string('vrn')->nullable();
            $table->string('slogan')->nullable();
            $table->string('logo')->nullable();
            $table->string('vat')->nullable();
            $table->string('receipt')->nullable(); // Yes or No
            $table->integer('royalty')->default(0); // 0 = off, 1 = on
            $table->integer('royalty_discount')->default(0); // %
            $table->integer('batch_no')->default(0); // 0 = off, 1 = on
            $table->integer('qrcode')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_profiles');
    }
};
