<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'role',
        'name',
        'phone',
        'email',
        'selling_id',
        'username',
        'password',
    ];

    public function selling()
    {
        return $this->belongsTo(Selling::class, 'selling_id');
    }

    public function profoma()
    {
        return $this->hasMany(ProfomaInvoice::class);
    }

    public function purchaseOrder()
    {
        return $this->hasMany(PurchaseOrder::class);
    }

    public function purchaseReturn()
    {
        return $this->hasMany(PurchaseReturn::class);
    }

    public function expense()
    {
        return $this->hasMany(PostExpense::class);
    }

    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }

    public function movement()
    {
        return $this->hasMany(StockMovement::class);
    }

    public function transfer()
    {
        return $this->hasMany(StockTransfer::class);
    }

    public function sales()
    {
        return $this->hasMany(Sale::class);
    }

    public function damage()
    {
        return $this->hasMany(Damage::class);
    }
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
