<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class  Unit extends Model
{
    use HasFactory, SoftDeletes;
    //use SoftDeletes;

    protected $fillable = ['name'];

    # Loaded items relation
    public function loadedItems()
    {
        return $this->hasMany(loadedItems::class);
    }

    # Requisition items relation
    public function requisitionItems()
    {
        return $this->hasMany(RequisitionItem::class);
    }

    public function serviceProduct()
    {
        return $this->hasMany(ServiceProduct::class);
    }

    public function menuItem()
    {
        return $this->hasMany(MenuItems::class);
    }

    public function damage()
    {
        return $this->hasMany(Damage::class);
    }

    public function ingredient()
    {
        return $this->hasMany(Ingredient::class);
    }

    public function movement()
    {
        return $this->hasMany(StockMovement::class);
    }

    public function transfer()
    {
        return $this->hasMany(StockTransfer::class);
    }

    public function soldItem()
    {
        return $this->hasMany(SoldItem::class);
    }

    public function stock()
    {
        return $this->hasMany(Stock::class);
    }

    public function assignedUnits()
    {
        return $this->hasMany(UnitAssigned::class);
    }

    public function purchasedItems()
    {
        return $this->hasMany(PurchasedItem::class);
    }

    public function production()
    {
        return $this->hasMany(ProductionOrderItem::class);
    }
}
