<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'date',
        'user_id',
        'reason',
        'status',
        'amount',
        'before',
        'after',
        'account_id',
        'location_id',
    ];

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }
}
