<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TableReservation extends Model
{
    use HasFactory;

    protected $fillable = [
        'table_id',
        'customer_name',
        'customer_phone',
        'guest_count',
        'booking_start',
        'booking_end',
        'status',
    ];

    /**
     * Casts to automatically convert to Carbon instances
     */
    protected $casts = [
        'booking_start' => 'datetime',
        'booking_end' => 'datetime',
    ];

    /**
     * Relationship to Table model
     */
    public function table()
    {
        return $this->belongsTo(Table::class);
    }

    /**
     * Accessor: Nicely formatted booking start
     */
    public function getFormattedStartAttribute()
    {
        return $this->booking_start
            ? $this->booking_start->format('d M Y, h:i A')
            : null;
    }

    /**
     * Accessor: Nicely formatted booking end
     */
    public function getFormattedEndAttribute()
    {
        return $this->booking_end
            ? $this->booking_end->format('d M Y, h:i A')
            : null;
    }

    /**
     * Scope: Only upcoming reservations
     */
    public function scopeUpcoming($query)
    {
        return $query->where('booking_start', '>=', now());
    }
}
