<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupplierDebts extends Model
{
    use HasFactory;
    protected $fillable = [
        'date',
        'purchase_id',
        'supplier_id',
        'opening_balance',
        'amount',
        'paid',
        'due',
        'selling_id',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }
}
