<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stock extends Model
{
    protected $fillable = [
        'product_id',
        'location_id',
        'unit_id',
        'qty',
        'min_qty',
        'min_cont',
        'exp',
        "exp_not",
        'batch_no'
    ];

    protected $dates = ['deleted_at'];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function unit(): BelongsTo
    {
        return $this->belongsTo(unit::class);
    }

    public function location(): BelongsTo
    {
        return $this->belongsTo(Location::class);
    }
}
