<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleReturn extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'date',
        'total',
        'account_id',
        'customer_id',
        'salling_id',
    ];

    # Account relation
      public function account()
    {
        return $this->belongsTo(Account::class);
    }

    # Customer relation
     public function customer()
    {
        return $this->hasMany(Customer::class);
    }

    # Selling relation
     public function selling()
    {
        return $this->hasMany(Selling::class);
    }


}

