<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'status',
        'block',
        'reason',
        'price',
        'selling_id',
    ];

    public function booking()
    {
        return $this->hasMany(Booking::class);
    }

    public function price()
    {
        return $this->hasMany(RoomPrice::class);
    }

    public function sale()
    {
        return $this->hasMany(Sale::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }
}
