<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProfomaInvoice extends Model
{
    use HasFactory;

    protected $fillable = ['date', 'user_id', 'customer_id', 'total', 'location_id'];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function user()
    {
        return $this->belongsTo(user::class);
    }

}
