<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Profoma extends Model
{
    use HasFactory;

    protected $fillable = ['date', 'user_id', 'customer_id', 'total', 'selling_id'];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function selling()
    {
        return $this->belongsTo(Selling::class);
    }

    public function user()
    {
        return $this->belongsTo(user::class);
    }

      public function profomaItems()
    {
        return $this->hasMany(ProfomaItems::class);
    }
}
