<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductionOrderItem extends Model
{
    use HasFactory;

     //create fillable array
     protected $fillable = [
        'production_order_id',
        'product_id',
        'unit_id',
        'unit_cont',
        'size',
        'color',
        'main_design',
        'sub_design',
        'qty',
        'price',
        'amount',
    ];

    //create relationship with production order
    public function order()
    {
        return $this->belongsTo(ProductionOrder::class);
    }

    //create relationship with product
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    //create relationship with unit
    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
}
